/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.util;

import com.apollographql.apollo3.api.Optional;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.dto.Form;
import io.camunda.tasklist.dto.Task;
import io.camunda.tasklist.dto.TaskState;
import io.camunda.tasklist.dto.Variable;
import io.camunda.tasklist.dto.VariableType;
import io.camunda.tasklist.exception.TaskListException;
import io.generated.tasklist.client.type.VariableInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApolloUtils {
    private static ObjectMapper objectMapper = null;

    private ApolloUtils() {
    }

    public static Optional<String> optional(String value) {
        return value == null ? null : new Optional.Present((Object)value);
    }

    public static Optional<Boolean> optional(Boolean value) {
        return value == null ? null : new Optional.Present((Object)value);
    }

    public static Optional<Integer> optional(Integer value) {
        return value == null ? null : new Optional.Present((Object)value);
    }

    public static Optional<io.generated.tasklist.client.type.TaskState> optional(TaskState value) {
        return value == null ? null : new Optional.Present((Object)io.generated.tasklist.client.type.TaskState.safeValueOf(value.getRawValue()));
    }

    public static Variable improveVariable(Variable var) throws JsonMappingException, JsonProcessingException {
        String value = (String)var.getValue();
        JsonNode nodeValue = ApolloUtils.getObjectMapper().readTree(value);
        if (nodeValue.canConvertToLong()) {
            var.setValue(nodeValue.asLong());
            var.setType(VariableType.NUMBER);
            return var;
        }
        if (nodeValue.isBoolean()) {
            var.setValue(nodeValue.asBoolean());
            var.setType(VariableType.BOOLEAN);
            return var;
        }
        if (nodeValue.isTextual()) {
            var.setValue(nodeValue.textValue());
            var.setType(VariableType.STRING);
            return var;
        }
        if (nodeValue.isArray()) {
            var.setValue(ApolloUtils.getObjectMapper().convertValue((Object)nodeValue, new TypeReference<List<?>>(){}));
            var.setType(VariableType.LIST);
            return var;
        }
        var.setValue(ApolloUtils.getObjectMapper().convertValue((Object)nodeValue, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        var.setType(VariableType.MAP);
        return var;
    }

    public static Task toTask(Object apolloTask) throws TaskListException {
        try {
            Task task = (Task)ApolloUtils.getObjectMapper().readValue(ApolloUtils.getObjectMapper().writeValueAsString(apolloTask), Task.class);
            if (task.getVariables() != null) {
                for (Variable var : task.getVariables()) {
                    ApolloUtils.improveVariable(var);
                }
            }
            return task;
        }
        catch (JsonProcessingException e) {
            throw new TaskListException((Exception)((Object)e));
        }
    }

    public static List<Task> toTasks(List<?> apolloTasks) throws TaskListException {
        ArrayList<Task> result = new ArrayList<Task>();
        for (Object apolloTask : apolloTasks) {
            result.add(ApolloUtils.toTask(apolloTask));
        }
        return result;
    }

    public static List<VariableInput> toVariableInput(Map<String, Object> variablesMap) throws TaskListException {
        try {
            ArrayList<VariableInput> variables = new ArrayList<VariableInput>();
            for (Map.Entry<String, Object> entry : variablesMap.entrySet()) {
                if (entry.getValue() == null) continue;
                variables.add(new VariableInput(entry.getKey(), ApolloUtils.getObjectMapper().writeValueAsString(entry.getValue())));
            }
            return variables;
        }
        catch (JsonProcessingException e) {
            throw new TaskListException((Exception)((Object)e));
        }
    }

    public static Form toForm(Object apolloTask) throws TaskListException {
        try {
            return (Form)ApolloUtils.getObjectMapper().readValue(ApolloUtils.getObjectMapper().writeValueAsString(apolloTask), Form.class);
        }
        catch (JsonProcessingException e) {
            throw new TaskListException((Exception)((Object)e));
        }
    }

    private static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return objectMapper;
    }
}

