/*
 * Tasklist REST API
 * Tasklist is a ready-to-use API application to rapidly implement business processes alongside user tasks in Zeebe.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.tasklist.generated.api;

import io.camunda.tasklist.generated.invoker.ApiClient;
import io.camunda.tasklist.generated.invoker.ApiException;
import io.camunda.tasklist.generated.invoker.ApiResponse;
import io.camunda.tasklist.generated.invoker.Pair;

import io.camunda.tasklist.generated.model.Error;
import io.camunda.tasklist.generated.model.FormResponse;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-09T10:15:52.317613093Z[Etc/UTC]", comments = "Generator version: 7.4.0")
public class FormApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public FormApi() {
    this(new ApiClient());
  }

  public FormApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * Get a form
   * Get the form details by &#x60;formId&#x60; and &#x60;processDefinitionKey&#x60; required query param. The &#x60;version&#x60; query param is optional and is used only for deployed forms (if empty, it retrieves the highest version).
   * @param formId The ID of the form. (required)
   * @param processDefinitionKey Reference to the process definition. (required)
   * @param version The version of the form. Valid only for deployed forms. (optional)
   * @return FormResponse
   * @throws ApiException if fails to make API call
   */
  public FormResponse getForm(String formId, String processDefinitionKey, Long version) throws ApiException {
    ApiResponse<FormResponse> localVarResponse = getFormWithHttpInfo(formId, processDefinitionKey, version);
    return localVarResponse.getData();
  }

  /**
   * Get a form
   * Get the form details by &#x60;formId&#x60; and &#x60;processDefinitionKey&#x60; required query param. The &#x60;version&#x60; query param is optional and is used only for deployed forms (if empty, it retrieves the highest version).
   * @param formId The ID of the form. (required)
   * @param processDefinitionKey Reference to the process definition. (required)
   * @param version The version of the form. Valid only for deployed forms. (optional)
   * @return ApiResponse&lt;FormResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<FormResponse> getFormWithHttpInfo(String formId, String processDefinitionKey, Long version) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getFormRequestBuilder(formId, processDefinitionKey, version);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getForm", localVarResponse);
        }
        return new ApiResponse<FormResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<FormResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getFormRequestBuilder(String formId, String processDefinitionKey, Long version) throws ApiException {
    // verify the required parameter 'formId' is set
    if (formId == null) {
      throw new ApiException(400, "Missing the required parameter 'formId' when calling getForm");
    }
    // verify the required parameter 'processDefinitionKey' is set
    if (processDefinitionKey == null) {
      throw new ApiException(400, "Missing the required parameter 'processDefinitionKey' when calling getForm");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/forms/{formId}"
        .replace("{formId}", ApiClient.urlEncode(formId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "processDefinitionKey";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("processDefinitionKey", processDefinitionKey));
    localVarQueryParameterBaseName = "version";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("version", version));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json, application/problem+json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
}
