/*
 * Tasklist REST API
 * Tasklist is a ready-to-use API application to rapidly implement business processes alongside user tasks in Zeebe.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.tasklist.generated.api;

import io.camunda.tasklist.generated.invoker.ApiClient;
import io.camunda.tasklist.generated.invoker.ApiException;
import io.camunda.tasklist.generated.invoker.ApiResponse;
import io.camunda.tasklist.generated.invoker.Pair;

import io.camunda.tasklist.generated.model.Error;
import io.camunda.tasklist.generated.model.SaveVariablesRequest;
import io.camunda.tasklist.generated.model.TaskAssignRequest;
import io.camunda.tasklist.generated.model.TaskCompleteRequest;
import io.camunda.tasklist.generated.model.TaskResponse;
import io.camunda.tasklist.generated.model.TaskSearchRequest;
import io.camunda.tasklist.generated.model.TaskSearchResponse;
import io.camunda.tasklist.generated.model.VariableSearchResponse;
import io.camunda.tasklist.generated.model.VariablesSearchRequest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-09T10:15:52.317613093Z[Etc/UTC]", comments = "Generator version: 7.4.0")
public class TaskApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public TaskApi() {
    this(new ApiClient());
  }

  public TaskApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * Assign a task
   * Assign a task with &#x60;taskId&#x60; to &#x60;assignee&#x60; or the active user. Returns the task.
   * @param taskId The ID of the task. (required)
   * @param taskAssignRequest When using REST API with JWT authentication token following request body parameters may be used. (optional)
   * @return TaskResponse
   * @throws ApiException if fails to make API call
   */
  public TaskResponse assignTask(String taskId, TaskAssignRequest taskAssignRequest) throws ApiException {
    ApiResponse<TaskResponse> localVarResponse = assignTaskWithHttpInfo(taskId, taskAssignRequest);
    return localVarResponse.getData();
  }

  /**
   * Assign a task
   * Assign a task with &#x60;taskId&#x60; to &#x60;assignee&#x60; or the active user. Returns the task.
   * @param taskId The ID of the task. (required)
   * @param taskAssignRequest When using REST API with JWT authentication token following request body parameters may be used. (optional)
   * @return ApiResponse&lt;TaskResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<TaskResponse> assignTaskWithHttpInfo(String taskId, TaskAssignRequest taskAssignRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = assignTaskRequestBuilder(taskId, taskAssignRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("assignTask", localVarResponse);
        }
        return new ApiResponse<TaskResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<TaskResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder assignTaskRequestBuilder(String taskId, TaskAssignRequest taskAssignRequest) throws ApiException {
    // verify the required parameter 'taskId' is set
    if (taskId == null) {
      throw new ApiException(400, "Missing the required parameter 'taskId' when calling assignTask");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tasks/{taskId}/assign"
        .replace("{taskId}", ApiClient.urlEncode(taskId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json, application/problem+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(taskAssignRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * Complete a task
   * Complete a task with &#x60;taskId&#x60; and optional &#x60;variables&#x60;. Returns the task.
   * @param taskId The ID of the task. (required)
   * @param taskCompleteRequest  (optional)
   * @return TaskResponse
   * @throws ApiException if fails to make API call
   */
  public TaskResponse completeTask(String taskId, TaskCompleteRequest taskCompleteRequest) throws ApiException {
    ApiResponse<TaskResponse> localVarResponse = completeTaskWithHttpInfo(taskId, taskCompleteRequest);
    return localVarResponse.getData();
  }

  /**
   * Complete a task
   * Complete a task with &#x60;taskId&#x60; and optional &#x60;variables&#x60;. Returns the task.
   * @param taskId The ID of the task. (required)
   * @param taskCompleteRequest  (optional)
   * @return ApiResponse&lt;TaskResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<TaskResponse> completeTaskWithHttpInfo(String taskId, TaskCompleteRequest taskCompleteRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = completeTaskRequestBuilder(taskId, taskCompleteRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("completeTask", localVarResponse);
        }
        return new ApiResponse<TaskResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<TaskResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder completeTaskRequestBuilder(String taskId, TaskCompleteRequest taskCompleteRequest) throws ApiException {
    // verify the required parameter 'taskId' is set
    if (taskId == null) {
      throw new ApiException(400, "Missing the required parameter 'taskId' when calling completeTask");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tasks/{taskId}/complete"
        .replace("{taskId}", ApiClient.urlEncode(taskId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json, application/problem+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(taskCompleteRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * Get a task
   * Get one task by id. Returns task or error when task does not exist.
   * @param taskId The ID of the task. (required)
   * @return TaskResponse
   * @throws ApiException if fails to make API call
   */
  public TaskResponse getTaskById(String taskId) throws ApiException {
    ApiResponse<TaskResponse> localVarResponse = getTaskByIdWithHttpInfo(taskId);
    return localVarResponse.getData();
  }

  /**
   * Get a task
   * Get one task by id. Returns task or error when task does not exist.
   * @param taskId The ID of the task. (required)
   * @return ApiResponse&lt;TaskResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<TaskResponse> getTaskByIdWithHttpInfo(String taskId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTaskByIdRequestBuilder(taskId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTaskById", localVarResponse);
        }
        return new ApiResponse<TaskResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<TaskResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTaskByIdRequestBuilder(String taskId) throws ApiException {
    // verify the required parameter 'taskId' is set
    if (taskId == null) {
      throw new ApiException(400, "Missing the required parameter 'taskId' when calling getTaskById");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tasks/{taskId}"
        .replace("{taskId}", ApiClient.urlEncode(taskId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json, application/problem+json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * Save draft variables
   * This operation performs several actions: &lt;br/&gt;&lt;ol&gt;&lt;li&gt;Validates the task and draft variables.&lt;/li&gt;&lt;li&gt;Deletes existing draft variables for the task.&lt;/li&gt;&lt;li&gt;Checks for new draft variables. If a new variable&#39;s &#x60;name&#x60; matches an existing one but the &#x60;value&#x60; differs, it is saved. In case of duplicate draft variable names, the last variable&#39;s value is kept.&lt;/li&gt;&lt;/ol&gt;&lt;b&gt;NOTE:&lt;/b&gt;&lt;ul&gt;&lt;li&gt;Invoking this method successively will overwrite all existing draft variables. Only draft variables submitted in the most recent request body will be persisted. Therefore, ensure you include all necessary variables in each request to maintain the intended variable set.&lt;/li&gt;&lt;li&gt;The UI does not currently display the values for draft variables that are created via this endpoint.&lt;/li&gt;&lt;/ul&gt;
   * @param taskId The ID of the task. (required)
   * @param saveVariablesRequest  (required)
   * @throws ApiException if fails to make API call
   */
  public void saveDraftTaskVariables(String taskId, SaveVariablesRequest saveVariablesRequest) throws ApiException {
    saveDraftTaskVariablesWithHttpInfo(taskId, saveVariablesRequest);
  }

  /**
   * Save draft variables
   * This operation performs several actions: &lt;br/&gt;&lt;ol&gt;&lt;li&gt;Validates the task and draft variables.&lt;/li&gt;&lt;li&gt;Deletes existing draft variables for the task.&lt;/li&gt;&lt;li&gt;Checks for new draft variables. If a new variable&#39;s &#x60;name&#x60; matches an existing one but the &#x60;value&#x60; differs, it is saved. In case of duplicate draft variable names, the last variable&#39;s value is kept.&lt;/li&gt;&lt;/ol&gt;&lt;b&gt;NOTE:&lt;/b&gt;&lt;ul&gt;&lt;li&gt;Invoking this method successively will overwrite all existing draft variables. Only draft variables submitted in the most recent request body will be persisted. Therefore, ensure you include all necessary variables in each request to maintain the intended variable set.&lt;/li&gt;&lt;li&gt;The UI does not currently display the values for draft variables that are created via this endpoint.&lt;/li&gt;&lt;/ul&gt;
   * @param taskId The ID of the task. (required)
   * @param saveVariablesRequest  (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> saveDraftTaskVariablesWithHttpInfo(String taskId, SaveVariablesRequest saveVariablesRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = saveDraftTaskVariablesRequestBuilder(taskId, saveVariablesRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("saveDraftTaskVariables", localVarResponse);
        }
        return new ApiResponse<Void>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          null
        );
      } finally {
        // Drain the InputStream
        while (localVarResponse.body().read() != -1) {
            // Ignore
        }
        localVarResponse.body().close();
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder saveDraftTaskVariablesRequestBuilder(String taskId, SaveVariablesRequest saveVariablesRequest) throws ApiException {
    // verify the required parameter 'taskId' is set
    if (taskId == null) {
      throw new ApiException(400, "Missing the required parameter 'taskId' when calling saveDraftTaskVariables");
    }
    // verify the required parameter 'saveVariablesRequest' is set
    if (saveVariablesRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'saveVariablesRequest' when calling saveDraftTaskVariables");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tasks/{taskId}/variables"
        .replace("{taskId}", ApiClient.urlEncode(taskId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "*/*, application/problem+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(saveVariablesRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * Search task variables
   * This method returns a list of task variables for the specified &#x60;taskId&#x60; and &#x60;variableName&#x60;.&lt;br&gt;If the request body is not provided or if the &#x60;variableNames&#x60; parameter in the request is empty, all variables associated with the task will be returned.
   * @param taskId The ID of the task. (required)
   * @param variablesSearchRequest  (optional)
   * @return List&lt;VariableSearchResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public List<VariableSearchResponse> searchTaskVariables(String taskId, VariablesSearchRequest variablesSearchRequest) throws ApiException {
    ApiResponse<List<VariableSearchResponse>> localVarResponse = searchTaskVariablesWithHttpInfo(taskId, variablesSearchRequest);
    return localVarResponse.getData();
  }

  /**
   * Search task variables
   * This method returns a list of task variables for the specified &#x60;taskId&#x60; and &#x60;variableName&#x60;.&lt;br&gt;If the request body is not provided or if the &#x60;variableNames&#x60; parameter in the request is empty, all variables associated with the task will be returned.
   * @param taskId The ID of the task. (required)
   * @param variablesSearchRequest  (optional)
   * @return ApiResponse&lt;List&lt;VariableSearchResponse&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<VariableSearchResponse>> searchTaskVariablesWithHttpInfo(String taskId, VariablesSearchRequest variablesSearchRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = searchTaskVariablesRequestBuilder(taskId, variablesSearchRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("searchTaskVariables", localVarResponse);
        }
        return new ApiResponse<List<VariableSearchResponse>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<VariableSearchResponse>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder searchTaskVariablesRequestBuilder(String taskId, VariablesSearchRequest variablesSearchRequest) throws ApiException {
    // verify the required parameter 'taskId' is set
    if (taskId == null) {
      throw new ApiException(400, "Missing the required parameter 'taskId' when calling searchTaskVariables");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tasks/{taskId}/variables/search"
        .replace("{taskId}", ApiClient.urlEncode(taskId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json, application/problem+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(variablesSearchRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * Search tasks
   * Returns the list of tasks that satisfy search request params.&lt;br&gt;&lt;ul&gt;&lt;li&gt;If an empty body is provided, all tasks are returned.&lt;/li&gt;&lt;li&gt;Only one of &#x60;[searchAfter, searchAfterOrEqual, searchBefore, searchBeforeOrEqual]&#x60; search options must be present in request.&lt;/li&gt;&lt;/ul&gt;
   * @param taskSearchRequest  (optional)
   * @return List&lt;TaskSearchResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public List<TaskSearchResponse> searchTasks(TaskSearchRequest taskSearchRequest) throws ApiException {
    ApiResponse<List<TaskSearchResponse>> localVarResponse = searchTasksWithHttpInfo(taskSearchRequest);
    return localVarResponse.getData();
  }

  /**
   * Search tasks
   * Returns the list of tasks that satisfy search request params.&lt;br&gt;&lt;ul&gt;&lt;li&gt;If an empty body is provided, all tasks are returned.&lt;/li&gt;&lt;li&gt;Only one of &#x60;[searchAfter, searchAfterOrEqual, searchBefore, searchBeforeOrEqual]&#x60; search options must be present in request.&lt;/li&gt;&lt;/ul&gt;
   * @param taskSearchRequest  (optional)
   * @return ApiResponse&lt;List&lt;TaskSearchResponse&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<TaskSearchResponse>> searchTasksWithHttpInfo(TaskSearchRequest taskSearchRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = searchTasksRequestBuilder(taskSearchRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("searchTasks", localVarResponse);
        }
        return new ApiResponse<List<TaskSearchResponse>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<TaskSearchResponse>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder searchTasksRequestBuilder(TaskSearchRequest taskSearchRequest) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tasks/search";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json, application/problem+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(taskSearchRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
  /**
   * Unassign a task
   * Unassign a task with &#x60;taskId&#x60;. Returns the task.
   * @param taskId The ID of the task. (required)
   * @return TaskResponse
   * @throws ApiException if fails to make API call
   */
  public TaskResponse unassignTask(String taskId) throws ApiException {
    ApiResponse<TaskResponse> localVarResponse = unassignTaskWithHttpInfo(taskId);
    return localVarResponse.getData();
  }

  /**
   * Unassign a task
   * Unassign a task with &#x60;taskId&#x60;. Returns the task.
   * @param taskId The ID of the task. (required)
   * @return ApiResponse&lt;TaskResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<TaskResponse> unassignTaskWithHttpInfo(String taskId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = unassignTaskRequestBuilder(taskId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("unassignTask", localVarResponse);
        }
        return new ApiResponse<TaskResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<TaskResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder unassignTaskRequestBuilder(String taskId) throws ApiException {
    // verify the required parameter 'taskId' is set
    if (taskId == null) {
      throw new ApiException(400, "Missing the required parameter 'taskId' when calling unassignTask");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/v1/tasks/{taskId}/unassign"
        .replace("{taskId}", ApiClient.urlEncode(taskId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json, application/problem+json");

    localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }
}
