/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.generated.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"assignee", "allowOverrideAssignment"})
public class TaskAssignRequest {
    public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
    private String assignee;
    public static final String JSON_PROPERTY_ALLOW_OVERRIDE_ASSIGNMENT = "allowOverrideAssignment";
    private Boolean allowOverrideAssignment = true;

    public TaskAssignRequest assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @JsonProperty(value="assignee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssignee() {
        return this.assignee;
    }

    @JsonProperty(value="assignee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public TaskAssignRequest allowOverrideAssignment(Boolean allowOverrideAssignment) {
        this.allowOverrideAssignment = allowOverrideAssignment;
        return this;
    }

    @Nullable
    @JsonProperty(value="allowOverrideAssignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowOverrideAssignment() {
        return this.allowOverrideAssignment;
    }

    @JsonProperty(value="allowOverrideAssignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowOverrideAssignment(Boolean allowOverrideAssignment) {
        this.allowOverrideAssignment = allowOverrideAssignment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskAssignRequest taskAssignRequest = (TaskAssignRequest)o;
        return Objects.equals(this.assignee, taskAssignRequest.assignee) && Objects.equals(this.allowOverrideAssignment, taskAssignRequest.allowOverrideAssignment);
    }

    public int hashCode() {
        return Objects.hash(this.assignee, this.allowOverrideAssignment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskAssignRequest {\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    allowOverrideAssignment: ").append(this.toIndentedString(this.allowOverrideAssignment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAssignee() != null) {
            joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssignee()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAllowOverrideAssignment() != null) {
            joiner.add(String.format("%sallowOverrideAssignment%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAllowOverrideAssignment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

