/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.CamundaTaskListClient;
import io.camunda.tasklist.CamundaTaskListClientProperties;
import io.camunda.tasklist.auth.Authentication;
import io.camunda.tasklist.auth.JwtAuthentication;
import io.camunda.tasklist.auth.JwtCredential;
import io.camunda.tasklist.auth.TokenResponseMapper;
import io.camunda.tasklist.exception.TaskListException;
import io.camunda.zeebe.client.ZeebeClient;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Duration;

public class CamundaTaskListClientBuilder {
    private CamundaTaskListClientProperties properties = new CamundaTaskListClientProperties();
    private ZeebeClient zeebeClient;

    public CamundaTaskListClientBuilder authentication(Authentication authentication) {
        this.properties.setAuthentication(authentication);
        return this;
    }

    public CamundaTaskListClientBuilder taskListUrl(String taskListUrl) {
        this.properties.setTaskListUrl(this.formatUrl(taskListUrl));
        return this;
    }

    public CamundaTaskListClientBuilder zeebeClient(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
        return this;
    }

    public CamundaTaskListClientBuilder shouldReturnVariables() {
        this.properties.setDefaultShouldReturnVariables(true);
        return this;
    }

    public CamundaTaskListClientBuilder shouldLoadTruncatedVariables() {
        this.properties.setDefaultShouldLoadTruncatedVariables(true);
        return this;
    }

    @Deprecated(forRemoval=true)
    public CamundaTaskListClientBuilder alwaysReconnect() {
        return this;
    }

    @Deprecated(forRemoval=true)
    public CamundaTaskListClientBuilder cookieExpiration(Duration cookieExpiration) {
        return this;
    }

    public CamundaTaskListClientBuilder useZeebeUserTasks() {
        this.properties.setUseZeebeUserTasks(true);
        return this;
    }

    public CamundaTaskListClient build() throws TaskListException {
        return new CamundaTaskListClient(this.properties, this.zeebeClient);
    }

    public CamundaTaskListClientBuilder selfManagedAuthentication(String clientId, String clientSecret, String keycloakUrl) {
        return this.selfManagedAuthentication(clientId, clientSecret, "tasklist-api", keycloakUrl);
    }

    public CamundaTaskListClientBuilder selfManagedAuthentication(String clientId, String clientSecret, String audience, String keycloakUrl) {
        return this.selfManagedAuthentication(clientId, clientSecret, "tasklist-api", null, keycloakUrl);
    }

    public CamundaTaskListClientBuilder selfManagedAuthentication(String clientId, String clientSecret, String audience, String scope, String authUrl) {
        try {
            this.properties.setAuthentication(new JwtAuthentication(new JwtCredential(clientId, clientSecret, audience, URI.create(authUrl).toURL(), scope), new TokenResponseMapper.JacksonTokenResponseMapper(new ObjectMapper())));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while parsing keycloak url", e);
        }
        return this;
    }

    public CamundaTaskListClientBuilder saaSAuthentication(String clientId, String clientSecret) {
        try {
            this.properties.setAuthentication(new JwtAuthentication(new JwtCredential(clientId, clientSecret, "tasklist.camunda.io", URI.create("https://login.cloud.camunda.io/oauth/token").toURL(), null), new TokenResponseMapper.JacksonTokenResponseMapper(new ObjectMapper())));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while parsing token url", e);
        }
        return this;
    }

    private String formatUrl(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }
}

