/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.exporter.BulkIndexRequest;
import io.camunda.zeebe.exporter.ElasticsearchExporterConfiguration;
import io.camunda.zeebe.exporter.ElasticsearchExporterException;
import io.camunda.zeebe.exporter.ElasticsearchMetrics;
import io.camunda.zeebe.exporter.RecordIndexRouter;
import io.camunda.zeebe.exporter.RestClientFactory;
import io.camunda.zeebe.exporter.TemplateReader;
import io.camunda.zeebe.exporter.dto.BulkIndexAction;
import io.camunda.zeebe.exporter.dto.BulkIndexResponse;
import io.camunda.zeebe.exporter.dto.PutIndexTemplateResponse;
import io.camunda.zeebe.exporter.dto.Template;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

class ElasticsearchClient
implements AutoCloseable {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final RestClient client;
    private final ElasticsearchExporterConfiguration configuration;
    private final TemplateReader templateReader;
    private final RecordIndexRouter indexRouter;
    private final BulkIndexRequest bulkIndexRequest;
    private ElasticsearchMetrics metrics;

    ElasticsearchClient(ElasticsearchExporterConfiguration configuration) {
        this(configuration, new BulkIndexRequest());
    }

    ElasticsearchClient(ElasticsearchExporterConfiguration configuration, BulkIndexRequest bulkIndexRequest) {
        this(configuration, bulkIndexRequest, RestClientFactory.of(configuration), new RecordIndexRouter(configuration.index), new TemplateReader(configuration.index), null);
    }

    ElasticsearchClient(ElasticsearchExporterConfiguration configuration, BulkIndexRequest bulkIndexRequest, RestClient client, RecordIndexRouter indexRouter, TemplateReader templateReader, ElasticsearchMetrics metrics) {
        this.configuration = configuration;
        this.bulkIndexRequest = bulkIndexRequest;
        this.client = client;
        this.indexRouter = indexRouter;
        this.templateReader = templateReader;
        this.metrics = metrics;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public void index(Record<?> record) {
        if (this.metrics == null) {
            this.metrics = new ElasticsearchMetrics(record.getPartitionId());
        }
        BulkIndexAction action = new BulkIndexAction(this.indexRouter.indexFor(record), this.indexRouter.idFor(record), this.indexRouter.routingFor(record));
        this.bulkIndexRequest.index(action, record);
    }

    public void flush() {
        if (this.bulkIndexRequest.isEmpty()) {
            return;
        }
        this.metrics.recordBulkSize(this.bulkIndexRequest.size());
        this.metrics.recordBulkMemorySize(this.bulkIndexRequest.memoryUsageBytes());
        try (Histogram.Timer ignored = this.metrics.measureFlushDuration();){
            this.exportBulk();
            this.bulkIndexRequest.clear();
        }
        catch (ElasticsearchExporterException e) {
            this.metrics.recordFailedFlush();
            throw e;
        }
    }

    public boolean shouldFlush() {
        return this.bulkIndexRequest.memoryUsageBytes() >= this.configuration.bulk.memoryLimit || this.bulkIndexRequest.size() >= this.configuration.bulk.size;
    }

    public boolean putIndexTemplate(ValueType valueType) {
        String templateName = this.indexRouter.indexPrefixForValueType(valueType);
        Template template = this.templateReader.readIndexTemplate(valueType, this.indexRouter.searchPatternForValueType(valueType), this.indexRouter.aliasNameForValueType(valueType));
        return this.putIndexTemplate(templateName, template);
    }

    public boolean putComponentTemplate() {
        Template template = this.templateReader.readComponentTemplate();
        return this.putComponentTemplate(template);
    }

    private void exportBulk() {
        BulkIndexResponse response;
        try {
            Request request = new Request("POST", "/_bulk");
            EntityTemplate body = new EntityTemplate((ContentProducer)this.bulkIndexRequest);
            body.setContentType("application/x-ndjson");
            request.setEntity((HttpEntity)body);
            response = this.sendRequest(request, BulkIndexResponse.class);
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to flush bulk", e);
        }
        if (response.errors()) {
            this.throwCollectedBulkError(response);
        }
    }

    private void throwCollectedBulkError(BulkIndexResponse bulkResponse) {
        ArrayList collectedErrors = new ArrayList();
        bulkResponse.items().stream().flatMap(item -> Optional.ofNullable(item.index()).stream()).flatMap(index -> Optional.ofNullable(index.error()).stream()).collect(Collectors.groupingBy(BulkIndexResponse.Error::type)).forEach((errorType, errors) -> collectedErrors.add(String.format("Failed to flush %d item(s) of bulk request [type: %s, reason: %s]", errors.size(), errorType, ((BulkIndexResponse.Error)errors.get(0)).reason())));
        throw new ElasticsearchExporterException("Failed to flush bulk request: " + collectedErrors);
    }

    private boolean putIndexTemplate(String templateName, Template template) {
        try {
            Request request = new Request("PUT", "/_index_template/" + templateName);
            request.setJsonEntity(MAPPER.writeValueAsString((Object)template));
            PutIndexTemplateResponse response = this.sendRequest(request, PutIndexTemplateResponse.class);
            return response.acknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to put index template", e);
        }
    }

    private boolean putComponentTemplate(Template template) {
        try {
            Request request = new Request("PUT", "/_component_template/" + this.configuration.index.prefix);
            request.setJsonEntity(MAPPER.writeValueAsString((Object)template));
            PutIndexTemplateResponse response = this.sendRequest(request, PutIndexTemplateResponse.class);
            return response.acknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to put component template", e);
        }
    }

    private <T> T sendRequest(Request request, Class<T> responseType) throws IOException {
        Response response = this.client.performRequest(request);
        byte[] responseBody = response.getEntity().getContent().readAllBytes();
        return (T)MAPPER.readValue(responseBody, responseType);
    }
}

