/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.exporter.ElasticsearchExporter;
import io.camunda.zeebe.exporter.ElasticsearchExporterConfiguration;
import io.camunda.zeebe.exporter.ElasticsearchExporterException;
import io.camunda.zeebe.exporter.dto.Template;
import io.camunda.zeebe.protocol.record.ValueType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

final class TemplateReader {
    private static final String INDEX_TEMPLATE_FILENAME_PATTERN = "/zeebe-record-%s-template.json";
    private static final String ZEEBE_RECORD_TEMPLATE_JSON = "/zeebe-record-template.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ElasticsearchExporterConfiguration.IndexConfiguration config;

    public TemplateReader(ElasticsearchExporterConfiguration.IndexConfiguration config) {
        this.config = config;
    }

    Template readComponentTemplate() {
        return this.readTemplate(ZEEBE_RECORD_TEMPLATE_JSON);
    }

    Template readIndexTemplate(ValueType valueType, String searchPattern, String aliasName) {
        Template template = this.readTemplate(this.findResourceForTemplate(valueType));
        template.composedOf().set(0, this.config.prefix);
        template.patterns().set(0, searchPattern);
        template.template().aliases().clear();
        template.template().aliases().put(aliasName, Collections.emptyMap());
        return template;
    }

    private String findResourceForTemplate(ValueType valueType) {
        return String.format(INDEX_TEMPLATE_FILENAME_PATTERN, this.valueTypeToString(valueType));
    }

    private String valueTypeToString(ValueType valueType) {
        return valueType.name().toLowerCase().replace("_", "-");
    }

    private Template readTemplate(String resourcePath) {
        Template template = this.getTemplateFromClasspath(resourcePath);
        Map<String, Object> settings = template.template().settings();
        this.substituteConfiguration(settings);
        return template;
    }

    private void substituteConfiguration(Map<String, Object> settings) {
        Integer numberOfReplicas;
        Integer numberOfShards = this.config.getNumberOfShards();
        if (numberOfShards != null) {
            settings.put("number_of_shards", numberOfShards);
        }
        if ((numberOfReplicas = this.config.getNumberOfReplicas()) != null) {
            settings.put("number_of_replicas", numberOfReplicas);
        }
    }

    private Template getTemplateFromClasspath(String filename) {
        Template template;
        block8: {
            InputStream inputStream = ElasticsearchExporter.class.getResourceAsStream(filename);
            try {
                template = (Template)MAPPER.readValue(inputStream, Template.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchExporterException("Failed to load index template from classpath " + filename, e);
                }
            }
            inputStream.close();
        }
        return template;
    }
}

