/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.dmn.DecisionContext;
import io.camunda.zeebe.dmn.DecisionEngine;
import io.camunda.zeebe.dmn.DecisionEvaluationResult;
import io.camunda.zeebe.dmn.EvaluatedDecision;
import io.camunda.zeebe.dmn.EvaluatedInput;
import io.camunda.zeebe.dmn.EvaluatedOutput;
import io.camunda.zeebe.dmn.MatchedRule;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.dmn.impl.VariablesContext;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCalledDecision;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.immutable.DecisionState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedDecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedInputRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedOutputRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.MatchedRuleRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

public final class BpmnDecisionBehavior {
    private static final DecisionInfo UNKNOWN_DECISION_INFO = new DecisionInfo(-1L, -1);
    private final DecisionEngine decisionEngine;
    private final DecisionState decisionState;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final VariableState variableState;
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;
    private final ExpressionProcessor expressionBehavior;
    private final ProcessEngineMetrics metrics;

    public BpmnDecisionBehavior(DecisionEngine decisionEngine, ProcessingState processingState, EventTriggerBehavior eventTriggerBehavior, StateWriter stateWriter, KeyGenerator keyGenerator, ExpressionProcessor expressionBehavior, ProcessEngineMetrics metrics) {
        this.decisionEngine = decisionEngine;
        this.decisionState = processingState.getDecisionState();
        this.variableState = processingState.getVariableState();
        this.eventTriggerBehavior = eventTriggerBehavior;
        this.stateWriter = stateWriter;
        this.keyGenerator = keyGenerator;
        this.expressionBehavior = expressionBehavior;
        this.metrics = metrics;
    }

    public Either<Failure, DecisionEvaluationResult> evaluateDecision(ExecutableCalledDecision element, BpmnElementContext context) {
        long scopeKey = context.getElementInstanceKey();
        Either<Failure, String> decisionIdOrFailure = this.evalDecisionIdExpression(element, scopeKey);
        if (decisionIdOrFailure.isLeft()) {
            return Either.left((Object)((Failure)decisionIdOrFailure.getLeft()));
        }
        String decisionId = (String)decisionIdOrFailure.get();
        Either<Failure, PersistedDecision> decisionOrFailure = this.findDecisionById(decisionId);
        Either resultOrFailure = decisionOrFailure.flatMap(this::findParsedDrgByDecision).mapLeft(failure -> new Failure("Expected to evaluate decision '%s', but %s".formatted(decisionId, failure.getMessage()))).mapLeft(f -> new Failure(f.getMessage(), ErrorType.CALLED_DECISION_ERROR, scopeKey)).flatMap(drg -> {
            DecisionEvaluationResult evaluationResult = this.evaluateDecisionInDrg((ParsedDecisionRequirementsGraph)drg, decisionId, scopeKey);
            PersistedDecision decision = (PersistedDecision)((Object)((Object)decisionOrFailure.get()));
            this.writeDecisionEvaluationEvent(decision, evaluationResult, context);
            if (evaluationResult.isFailure()) {
                this.metrics.increaseFailedEvaluatedDmnElements(evaluationResult.getEvaluatedDecisions().size());
                return Either.left((Object)new Failure(evaluationResult.getFailureMessage(), ErrorType.DECISION_EVALUATION_ERROR, scopeKey));
            }
            this.metrics.increaseSuccessfullyEvaluatedDmnElements(evaluationResult.getEvaluatedDecisions().size());
            return Either.right((Object)evaluationResult);
        });
        resultOrFailure.ifRight(result -> this.triggerProcessEventWithResultVariable(context, element.getResultVariable(), (DecisionEvaluationResult)result));
        return resultOrFailure;
    }

    private Either<Failure, String> evalDecisionIdExpression(ExecutableCalledDecision element, long scopeKey) {
        return this.expressionBehavior.evaluateStringExpression(element.getDecisionId(), scopeKey);
    }

    private Either<Failure, PersistedDecision> findDecisionById(String decisionId) {
        return Either.ofOptional(this.decisionState.findLatestDecisionById(BufferUtil.wrapString((String)decisionId))).orElse((Object)new Failure("no decision found for id '%s'".formatted(decisionId)));
    }

    public Either<Failure, ParsedDecisionRequirementsGraph> findParsedDrgByDecision(PersistedDecision persistedDecision) {
        return this.findDrgByDecision(persistedDecision).map(DeployedDrg::getParsedDecisionRequirements);
    }

    private Either<Failure, DeployedDrg> findDrgByDecision(PersistedDecision decision) {
        long key = decision.getDecisionRequirementsKey();
        DirectBuffer id = decision.getDecisionRequirementsId();
        return Either.ofOptional(this.decisionState.findDecisionRequirementsByKey(key)).orElse((Object)new Failure("no drg found for id '%s'".formatted(BufferUtil.bufferAsString((DirectBuffer)id))));
    }

    private Either<Failure, ParsedDecisionRequirementsGraph> parseDrg(DirectBuffer resource) {
        return Either.right((Object)resource).map(BufferUtil::bufferAsArray).map(ByteArrayInputStream::new).map(arg_0 -> ((DecisionEngine)this.decisionEngine).parse(arg_0)).flatMap(parseResult -> {
            if (parseResult.isValid()) {
                return Either.right((Object)parseResult);
            }
            return Either.left((Object)new Failure(parseResult.getFailureMessage()));
        });
    }

    private DecisionEvaluationResult evaluateDecisionInDrg(ParsedDecisionRequirementsGraph drg, String decisionId, long scopeKey) {
        DirectBuffer variables = this.variableState.getVariablesAsDocument(scopeKey);
        VariablesContext evaluationContext = new VariablesContext(MsgPackConverter.convertToMap((DirectBuffer)variables));
        return this.decisionEngine.evaluateDecisionById(drg, decisionId, (DecisionContext)evaluationContext);
    }

    private void triggerProcessEventWithResultVariable(BpmnElementContext context, String resultVariableName, DecisionEvaluationResult result) {
        DirectBuffer resultVariable = BpmnDecisionBehavior.serializeToNamedVariable(resultVariableName, result.getOutput());
        this.eventTriggerBehavior.triggeringProcessEvent(context.getProcessDefinitionKey(), context.getProcessInstanceKey(), context.getElementInstanceKey(), context.getElementId(), resultVariable);
    }

    private static DirectBuffer serializeToNamedVariable(String name, DirectBuffer value) {
        ExpandableArrayBuffer resultBuffer = new ExpandableArrayBuffer();
        MsgPackWriter writer = new MsgPackWriter();
        writer.wrap((MutableDirectBuffer)resultBuffer, 0);
        writer.writeMapHeader(1);
        writer.writeString(BufferUtil.wrapString((String)name));
        writer.writeRaw(value);
        return resultBuffer;
    }

    private void writeDecisionEvaluationEvent(PersistedDecision decision, DecisionEvaluationResult decisionResult, BpmnElementContext context) {
        DecisionEvaluationIntent decisionEvaluationIntent;
        DecisionEvaluationRecord decisionEvaluationEvent = new DecisionEvaluationRecord().setDecisionKey(decision.getDecisionKey()).setDecisionId(decision.getDecisionId()).setDecisionName(decision.getDecisionName()).setDecisionVersion(decision.getVersion()).setDecisionRequirementsKey(decision.getDecisionRequirementsKey()).setDecisionRequirementsId(decision.getDecisionRequirementsId()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setBpmnProcessId(context.getBpmnProcessId()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementInstanceKey(context.getElementInstanceKey()).setElementId(context.getElementId());
        Map<String, DecisionInfo> decisionKeysByDecisionId = this.decisionState.findDecisionsByDecisionRequirementsKey(decision.getDecisionRequirementsKey()).stream().collect(Collectors.toMap(persistedDecision -> BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId()), DecisionInfo::new));
        decisionResult.getEvaluatedDecisions().forEach(evaluatedDecision -> this.addDecisionToEvaluationEvent((EvaluatedDecision)evaluatedDecision, decisionKeysByDecisionId.getOrDefault(evaluatedDecision.decisionId(), UNKNOWN_DECISION_INFO), decisionEvaluationEvent));
        if (decisionResult.isFailure()) {
            decisionEvaluationIntent = DecisionEvaluationIntent.FAILED;
            decisionEvaluationEvent.setEvaluationFailureMessage(decisionResult.getFailureMessage()).setFailedDecisionId(decisionResult.getFailedDecisionId());
        } else {
            decisionEvaluationIntent = DecisionEvaluationIntent.EVALUATED;
            decisionEvaluationEvent.setDecisionOutput(decisionResult.getOutput());
        }
        long newDecisionEvaluationKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(newDecisionEvaluationKey, (Intent)decisionEvaluationIntent, (RecordValue)decisionEvaluationEvent);
    }

    private void addDecisionToEvaluationEvent(EvaluatedDecision evaluatedDecision, DecisionInfo decisionInfo, DecisionEvaluationRecord decisionEvaluationEvent) {
        EvaluatedDecisionRecord evaluatedDecisionRecord = (EvaluatedDecisionRecord)decisionEvaluationEvent.evaluatedDecisions().add();
        evaluatedDecisionRecord.setDecisionId(evaluatedDecision.decisionId()).setDecisionName(evaluatedDecision.decisionName()).setDecisionKey(decisionInfo.key()).setDecisionVersion(decisionInfo.version()).setDecisionType(evaluatedDecision.decisionType().name()).setDecisionOutput(evaluatedDecision.decisionOutput());
        evaluatedDecision.evaluatedInputs().forEach(evaluatedInput -> this.addInputToEvaluationEvent((EvaluatedInput)evaluatedInput, evaluatedDecisionRecord));
        evaluatedDecision.matchedRules().forEach(matchedRule -> this.addMatchedRuleToEvaluationEvent((MatchedRule)matchedRule, evaluatedDecisionRecord));
    }

    private void addInputToEvaluationEvent(EvaluatedInput evaluatedInput, EvaluatedDecisionRecord evaluatedDecisionRecord) {
        EvaluatedInputRecord inputRecord = ((EvaluatedInputRecord)evaluatedDecisionRecord.evaluatedInputs().add()).setInputId(evaluatedInput.inputId()).setInputValue(evaluatedInput.inputValue());
        if (evaluatedInput.inputName() != null) {
            inputRecord.setInputName(evaluatedInput.inputName());
        }
    }

    private void addMatchedRuleToEvaluationEvent(MatchedRule matchedRule, EvaluatedDecisionRecord evaluatedDecisionRecord) {
        MatchedRuleRecord matchedRuleRecord = (MatchedRuleRecord)evaluatedDecisionRecord.matchedRules().add();
        matchedRuleRecord.setRuleId(matchedRule.ruleId()).setRuleIndex(matchedRule.ruleIndex());
        matchedRule.evaluatedOutputs().forEach(evaluatedOutput -> this.addOutputToEvaluationEvent((EvaluatedOutput)evaluatedOutput, matchedRuleRecord));
    }

    private void addOutputToEvaluationEvent(EvaluatedOutput evaluatedOutput, MatchedRuleRecord matchedRuleRecord) {
        EvaluatedOutputRecord outputRecord = ((EvaluatedOutputRecord)matchedRuleRecord.evaluatedOutputs().add()).setOutputId(evaluatedOutput.outputId()).setOutputValue(evaluatedOutput.outputValue());
        if (evaluatedOutput.outputName() != null) {
            outputRecord.setOutputName(evaluatedOutput.outputName());
        }
    }

    private record DecisionInfo(long key, int version) {
        DecisionInfo(PersistedDecision persistedDecision) {
            this(persistedDecision.getDecisionKey(), persistedDecision.getVersion());
        }
    }
}

