/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.job.JobBackoffChecker;
import io.camunda.zeebe.engine.processing.job.JobCommandPreconditionChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public final class JobFailProcessor
implements TypedRecordProcessor<JobRecord> {
    private static final DirectBuffer DEFAULT_ERROR_MESSAGE = BufferUtil.wrapString((String)"No more retries left.");
    private final IncidentRecord incidentEvent = new IncidentRecord();
    private final JobState jobState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final KeyGenerator keyGenerator;
    private final JobMetrics jobMetrics;
    private final JobBackoffChecker jobBackoffChecker;
    private final SideEffectWriter sideEffectWriter;
    private final JobCommandPreconditionChecker preconditionChecker;

    public JobFailProcessor(ProcessingState state, Writers writers, KeyGenerator keyGenerator, JobMetrics jobMetrics, JobBackoffChecker jobBackoffChecker) {
        this.jobState = state.getJobState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.sideEffectWriter = writers.sideEffect();
        this.preconditionChecker = new JobCommandPreconditionChecker("fail", List.of(JobState.State.ACTIVATABLE, JobState.State.ACTIVATED));
        this.keyGenerator = keyGenerator;
        this.jobBackoffChecker = jobBackoffChecker;
        this.jobMetrics = jobMetrics;
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record) {
        long jobKey = record.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        this.preconditionChecker.check(state, jobKey).ifRightOrLeft(ok -> this.failJob(record), violation -> {
            this.rejectionWriter.appendRejection(record, (RejectionType)violation.getLeft(), (String)violation.getRight());
            this.responseWriter.writeRejectionOnCommand(record, (RejectionType)violation.getLeft(), (String)violation.getRight());
        });
    }

    private void failJob(TypedRecord<JobRecord> record) {
        long jobKey = record.getKey();
        JobRecord failJobCommandRecord = record.getValue();
        int retries = failJobCommandRecord.getRetries();
        long retryBackOff = failJobCommandRecord.getRetryBackoff();
        JobRecord failedJob = this.jobState.getJob(jobKey);
        failedJob.setRetries(retries);
        failedJob.setErrorMessage(StringUtil.limitString((String)failJobCommandRecord.getErrorMessage(), (int)10000));
        failedJob.setRetryBackoff(retryBackOff);
        failedJob.setVariables(failJobCommandRecord.getVariablesBuffer());
        if (retries > 0 && retryBackOff > 0L) {
            long receivedTime = record.getTimestamp();
            failedJob.setRecurringTime(receivedTime + retryBackOff);
            this.sideEffectWriter.appendSideEffect(() -> {
                this.jobBackoffChecker.scheduleBackOff(retryBackOff + receivedTime);
                return true;
            });
        }
        this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.FAILED, (RecordValue)failedJob);
        this.responseWriter.writeEventOnCommand(jobKey, (Intent)JobIntent.FAILED, (UnpackedObject)failedJob, record);
        this.jobMetrics.jobFailed(failedJob.getType());
        if (retries <= 0) {
            this.raiseIncident(jobKey, failedJob);
        }
    }

    private void raiseIncident(long key, JobRecord value) {
        DirectBuffer jobErrorMessage = value.getErrorMessageBuffer();
        DirectBuffer incidentErrorMessage = DEFAULT_ERROR_MESSAGE;
        if (jobErrorMessage.capacity() > 0) {
            incidentErrorMessage = jobErrorMessage;
        }
        this.incidentEvent.reset();
        this.incidentEvent.setErrorType(ErrorType.JOB_NO_RETRIES).setErrorMessage(incidentErrorMessage).setBpmnProcessId(value.getBpmnProcessIdBuffer()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setElementId(value.getElementIdBuffer()).setElementInstanceKey(value.getElementInstanceKey()).setJobKey(key).setVariableScopeKey(value.getElementInstanceKey());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)IncidentIntent.CREATED, (RecordValue)this.incidentEvent);
    }
}

