/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandContext;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandHandlers;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;

public final class ProcessInstanceCommandProcessor
implements TypedRecordProcessor<ProcessInstanceRecord> {
    private final ProcessInstanceCommandHandlers commandHandlers;
    private final ElementInstanceState elementInstanceState;
    private final ProcessInstanceCommandContext context;

    public ProcessInstanceCommandProcessor(Writers writers, MutableElementInstanceState elementInstanceState) {
        this.elementInstanceState = elementInstanceState;
        this.commandHandlers = new ProcessInstanceCommandHandlers();
        this.context = new ProcessInstanceCommandContext(elementInstanceState, writers);
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceRecord> record) {
        this.populateCommandContext(record);
        this.commandHandlers.handle(this.context);
    }

    private void populateCommandContext(TypedRecord<ProcessInstanceRecord> record) {
        this.context.setRecord(record);
        ElementInstance elementInstance = this.elementInstanceState.getInstance(record.getKey());
        this.context.setElementInstance(elementInstance);
    }
}

