/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.CopiedRecord;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.util.ReflectUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class CopiedRecords {
    private CopiedRecords() {
    }

    public static CopiedRecord createCopiedRecord(int partitionId, LoggedEvent rawEvent) {
        DirectBuffer contentBuffer = rawEvent.getValueBuffer();
        byte[] metadataBytes = new byte[rawEvent.getMetadataLength()];
        contentBuffer.getBytes(rawEvent.getMetadataOffset(), metadataBytes);
        UnsafeBuffer metadataBuffer = new UnsafeBuffer(metadataBytes);
        RecordMetadata metadata = new RecordMetadata();
        metadata.wrap((DirectBuffer)metadataBuffer, 0, metadataBuffer.capacity());
        byte[] valueBytes = new byte[rawEvent.getValueLength()];
        contentBuffer.getBytes(rawEvent.getValueOffset(), valueBytes);
        UnsafeBuffer valueBuffer = new UnsafeBuffer(valueBytes);
        UnifiedRecordValue recordValue = (UnifiedRecordValue)ReflectUtil.newInstance(TypedEventRegistry.EVENT_REGISTRY.get(metadata.getValueType()));
        recordValue.wrap((DirectBuffer)valueBuffer);
        return new CopiedRecord(recordValue, metadata, rawEvent.getKey(), partitionId, rawEvent.getPosition(), rawEvent.getSourceEventPosition(), rawEvent.getTimestamp());
    }
}

