/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.MigrationTaskState;
import io.camunda.zeebe.engine.state.migration.TemporaryVariables;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class DbMigrationState
implements MutableMigrationState {
    private static final MigrationTaskState.State MIGRATION_TASK_FINISHED_STATE = MigrationTaskState.State.FINISHED;
    private final DbString migrationIdentifier = new DbString();
    private final MigrationTaskState migrationTaskState = new MigrationTaskState();
    private final ColumnFamily<DbString, MigrationTaskState> migrationStateColumnFamily;
    private final DbLong messageSubscriptionSentTime;
    private final DbLong messageSubscriptionElementInstanceKey;
    private final DbString messageSubscriptionMessageName;
    private final DbCompositeKey<DbLong, DbString> messageSubscriptionElementKeyAndMessageName;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> messageSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> messageSubscriptionSentTimeColumnFamily;
    private final DbLong processSubscriptionSentTime;
    private final DbLong processSubscriptionElementInstanceKey;
    private final DbString processSubscriptionMessageName;
    private final DbCompositeKey<DbLong, DbString> processSubscriptionElementKeyAndMessageName;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> processSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> processSubscriptionSentTimeColumnFamily;
    private final ColumnFamily<DbLong, TemporaryVariables> temporaryVariableColumnFamily;

    public DbMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.migrationStateColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MIGRATIONS_STATE, transactionContext, (DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
        this.messageSubscriptionElementInstanceKey = new DbLong();
        this.messageSubscriptionMessageName = new DbString();
        this.messageSubscriptionElementKeyAndMessageName = new DbCompositeKey((DbKey)this.messageSubscriptionElementInstanceKey, (DbKey)this.messageSubscriptionMessageName);
        this.messageSubscriptionSentTime = new DbLong();
        this.messageSubscriptionSentTimeCompositeKey = new DbCompositeKey((DbKey)this.messageSubscriptionSentTime, this.messageSubscriptionElementKeyAndMessageName);
        this.messageSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.messageSubscriptionSentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        this.processSubscriptionElementInstanceKey = new DbLong();
        this.processSubscriptionMessageName = new DbString();
        this.processSubscriptionElementKeyAndMessageName = new DbCompositeKey((DbKey)this.processSubscriptionElementInstanceKey, (DbKey)this.processSubscriptionMessageName);
        this.processSubscriptionSentTime = new DbLong();
        this.processSubscriptionSentTimeCompositeKey = new DbCompositeKey((DbKey)this.processSubscriptionSentTime, this.processSubscriptionElementKeyAndMessageName);
        this.processSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.processSubscriptionSentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        DbLong temporaryVariablesKeyInstance = new DbLong();
        TemporaryVariables temporaryVariablesValue = new TemporaryVariables();
        this.temporaryVariableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TEMPORARY_VARIABLE_STORE, transactionContext, (DbKey)temporaryVariablesKeyInstance, (DbValue)temporaryVariablesValue);
    }

    @Override
    public void migrateMessageSubscriptionSentTime(MutableMessageSubscriptionState messageSubscriptionState, MutablePendingMessageSubscriptionState transientState) {
        this.messageSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.first()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.second();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.first()).getValue();
            MessageSubscription messageSubscription = messageSubscriptionState.get(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.second()).getBuffer());
            if (messageSubscription != null) {
                messageSubscriptionState.updateToCorrelatingState(messageSubscription.getRecord());
                transientState.updateCommandSentTime(messageSubscription.getRecord(), sentTime);
            }
            this.messageSubscriptionSentTimeColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void migrateProcessMessageSubscriptionSentTime(MutableProcessMessageSubscriptionState persistentState, MutablePendingProcessMessageSubscriptionState transientState) {
        this.processSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.first()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.second();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.first()).getValue();
            ProcessMessageSubscription processMessageSubscription = persistentState.getSubscription(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.second()).getBuffer());
            if (processMessageSubscription != null) {
                ProcessMessageSubscriptionRecord record = processMessageSubscription.getRecord();
                ProcessMessageSubscriptionRecord exclusiveCopy = new ProcessMessageSubscriptionRecord();
                exclusiveCopy.wrap(record);
                if (processMessageSubscription.isOpening()) {
                    persistentState.updateToOpeningState(exclusiveCopy);
                    transientState.updateSentTime(exclusiveCopy, sentTime);
                } else if (processMessageSubscription.isClosing()) {
                    persistentState.updateToClosingState(exclusiveCopy);
                    transientState.updateSentTime(exclusiveCopy, sentTime);
                }
            }
            this.processSubscriptionSentTimeColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void migrateTemporaryVariables(MutableEventScopeInstanceState eventScopeInstanceState, MutableElementInstanceState elementInstanceState) {
        this.temporaryVariableColumnFamily.forEach((key, value) -> {
            long eventKey = -1L;
            String elementId = "migrated-variable-" + key.getValue();
            DirectBuffer elementIdBuffer = BufferUtil.wrapString((String)elementId);
            ElementInstance elementInstance = elementInstanceState.getInstance(key.getValue());
            if (elementInstance != null && elementInstance.getValue().getBpmnElementType().equals((Object)BpmnElementType.EVENT_SUB_PROCESS)) {
                long flowScopeKey = elementInstance.getValue().getFlowScopeKey();
                eventScopeInstanceState.triggerStartEvent(flowScopeKey, -1L, elementIdBuffer, value.get(), elementInstance.getValue().getProcessInstanceKey());
                while (eventScopeInstanceState.pollEventTrigger(key.getValue()) != null) {
                }
            } else {
                eventScopeInstanceState.triggerStartEvent(key.getValue(), -1L, elementIdBuffer, value.get(), -1L);
            }
            this.temporaryVariableColumnFamily.deleteExisting((DbKey)key);
        });
    }

    @Override
    public void markMigrationFinished(String identifier) {
        this.migrationIdentifier.wrapString(identifier);
        this.migrationStateColumnFamily.insert((DbKey)this.migrationIdentifier, (DbValue)new MigrationTaskState().setState(MIGRATION_TASK_FINISHED_STATE));
    }

    @Override
    public boolean isMigrationFinished(String identifier) {
        this.migrationIdentifier.wrapString(identifier);
        MigrationTaskState migrationState = (MigrationTaskState)this.migrationStateColumnFamily.get((DbKey)this.migrationIdentifier);
        return migrationState != null && migrationState.getState() == MIGRATION_TASK_FINISHED_STATE;
    }
}

