/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.api.SimpleProcessingScheduleService;
import io.camunda.zeebe.engine.api.Task;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import java.time.Duration;

public class ExtendedProcessingScheduleServiceImpl
implements ProcessingScheduleService {
    private final SimpleProcessingScheduleService processorActorService;
    private final SimpleProcessingScheduleService asyncActorService;
    private final ConcurrencyControl concurrencyControl;

    public ExtendedProcessingScheduleServiceImpl(SimpleProcessingScheduleService processorActorService, SimpleProcessingScheduleService asyncActorService, ConcurrencyControl concurrencyControl) {
        this.processorActorService = processorActorService;
        this.asyncActorService = asyncActorService;
        this.concurrencyControl = concurrencyControl;
    }

    @Override
    public void runAtFixedRateAsync(Duration delay, Task task) {
        this.concurrencyControl.run(() -> this.asyncActorService.runAtFixedRate(delay, task));
    }

    @Override
    public void runDelayedAsync(Duration delay, Task task) {
        this.concurrencyControl.run(() -> this.asyncActorService.runDelayed(delay, task));
    }

    @Override
    public void runDelayed(Duration delay, Runnable task) {
        this.processorActorService.runDelayed(delay, task);
    }

    @Override
    public void runDelayed(Duration delay, Task task) {
        this.processorActorService.runDelayed(delay, task);
    }

    @Override
    public void runAtFixedRate(Duration delay, Task task) {
        this.processorActorService.runAtFixedRate(delay, task);
    }
}

