/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.api.SimpleProcessingScheduleService;
import io.camunda.zeebe.engine.api.Task;
import io.camunda.zeebe.engine.api.TaskResult;
import io.camunda.zeebe.logstreams.log.LogStreamBatchWriter;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.retry.AbortableRetryStrategy;
import io.camunda.zeebe.streamprocessor.BufferedTaskResultBuilder;
import io.camunda.zeebe.streamprocessor.StreamProcessor;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.time.Duration;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class ProcessingScheduleServiceImpl
implements SimpleProcessingScheduleService,
AutoCloseable {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final Supplier<StreamProcessor.Phase> streamProcessorPhaseSupplier;
    private final BooleanSupplier abortCondition;
    private final Supplier<ActorFuture<LogStreamBatchWriter>> writerAsyncSupplier;
    private LogStreamBatchWriter logStreamBatchWriter;
    private ActorControl actorControl;
    private AbortableRetryStrategy writeRetryStrategy;
    private CompletableActorFuture<Void> openFuture;

    public ProcessingScheduleServiceImpl(Supplier<StreamProcessor.Phase> streamProcessorPhaseSupplier, BooleanSupplier abortCondition, Supplier<ActorFuture<LogStreamBatchWriter>> writerAsyncSupplier) {
        this.streamProcessorPhaseSupplier = streamProcessorPhaseSupplier;
        this.abortCondition = abortCondition;
        this.writerAsyncSupplier = writerAsyncSupplier;
    }

    @Override
    public void runDelayed(Duration delay, Runnable followUpTask) {
        this.useActorControl(() -> this.actorControl.runDelayed(delay, followUpTask));
    }

    @Override
    public void runDelayed(Duration delay, Task task) {
        this.runDelayed(delay, this.toRunnable(task));
    }

    @Override
    public void runAtFixedRate(Duration delay, Task task) {
        this.runDelayed(delay, this.toRunnable(builder -> {
            try {
                TaskResult taskResult = task.execute(builder);
                return taskResult;
            }
            finally {
                this.runAtFixedRate(delay, task);
            }
        }));
    }

    private void useActorControl(Runnable task) {
        if (this.actorControl == null) {
            LOG.debug("ProcessingScheduleService hasn't been opened yet, ignore scheduled task.");
            return;
        }
        task.run();
    }

    public ActorFuture<Void> open(ActorControl control) {
        if (this.openFuture != null) {
            return this.openFuture;
        }
        this.openFuture = new CompletableActorFuture();
        this.writeRetryStrategy = new AbortableRetryStrategy(control);
        ActorFuture<LogStreamBatchWriter> writerFuture = this.writerAsyncSupplier.get();
        control.runOnCompletion(writerFuture, (writer, failure) -> {
            if (failure == null) {
                this.logStreamBatchWriter = writer;
                this.actorControl = control;
                this.openFuture.complete(null);
            } else {
                this.openFuture.completeExceptionally(failure);
            }
        });
        return this.openFuture;
    }

    @Override
    public void close() {
        this.actorControl = null;
        this.logStreamBatchWriter = null;
        this.writeRetryStrategy = null;
        this.openFuture = null;
    }

    Runnable toRunnable(Task task) {
        return () -> {
            if (this.abortCondition.getAsBoolean()) {
                return;
            }
            StreamProcessor.Phase currentStreamProcessorPhase = this.streamProcessorPhaseSupplier.get();
            if (currentStreamProcessorPhase != StreamProcessor.Phase.PROCESSING) {
                LOG.trace("Not able to execute scheduled task right now. [streamProcessorPhase: {}]", (Object)currentStreamProcessorPhase);
                this.actorControl.submit(this.toRunnable(task));
                return;
            }
            BufferedTaskResultBuilder builder = new BufferedTaskResultBuilder((arg_0, arg_1) -> ((LogStreamBatchWriter)this.logStreamBatchWriter).canWriteAdditionalEvent(arg_0, arg_1));
            TaskResult result = task.execute(builder);
            this.logStreamBatchWriter.reset();
            result.getRecordBatch().forEach(entry -> this.logStreamBatchWriter.event().key(entry.key()).metadataWriter((BufferWriter)entry.recordMetadata()).sourceIndex(entry.sourceIndex()).valueWriter((BufferWriter)entry.recordValue()).done());
            ActorFuture writeFuture = this.writeRetryStrategy.runWithRetry(() -> {
                LOG.trace("Write scheduled TaskResult to dispatcher!");
                return this.logStreamBatchWriter.tryWrite() >= 0L;
            }, this.abortCondition);
            writeFuture.onComplete((v, t) -> {
                if (t != null) {
                    LOG.warn("Writing of scheduled TaskResult failed!", t);
                }
            });
        };
    }
}

