/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.restore;

import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.backup.s3.S3BackupConfig;
import io.camunda.zeebe.backup.s3.S3BackupStore;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.backup.BackupStoreCfg;
import io.camunda.zeebe.broker.system.configuration.backup.S3BackupStoreConfig;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
final class BackupStoreComponent {
    private final BrokerCfg brokerCfg;

    @Autowired
    BackupStoreComponent(BrokerCfg brokerCfg) {
        this.brokerCfg = brokerCfg;
    }

    @Bean(destroyMethod="closeAsync")
    BackupStore backupStore() {
        return this.buildBackupStore(this.brokerCfg.getData().getBackup());
    }

    private BackupStore buildBackupStore(BackupStoreCfg backupCfg) {
        BackupStoreCfg.BackupStoreType store = backupCfg.getStore();
        if (store == BackupStoreCfg.BackupStoreType.NONE) {
            throw new IllegalArgumentException("No backup store configured, cannot restore from backup.");
        }
        if (store == BackupStoreCfg.BackupStoreType.S3) {
            S3BackupStoreConfig s3Config = backupCfg.getS3();
            S3BackupConfig storeConfig = S3BackupConfig.from((String)s3Config.getBucketName(), (String)s3Config.getEndpoint(), (String)s3Config.getRegion(), (String)s3Config.getAccessKey(), (String)s3Config.getSecretKey(), (Duration)s3Config.getApiCallTimeout());
            return new S3BackupStore(storeConfig);
        }
        throw new IllegalArgumentException("The configured backup store type (%s) is unsupported. Cannot restore from backup".formatted(store));
    }
}

