/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared;

import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.shared.management.ActorClockService;
import io.camunda.zeebe.shared.management.ControlledActorClockService;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.context.annotation.Bean;

@ConfigurationProperties(value="zeebe.clock")
public final class ActorClockConfiguration {
    private final Optional<ActorClock> clock;
    private final ActorClockService service;

    @ConstructorBinding
    public ActorClockConfiguration(@DefaultValue(value={"false"}) boolean controlled) {
        if (controlled) {
            ControlledActorClock controlledClock = new ControlledActorClock();
            this.service = new ControlledActorClockService(controlledClock);
            this.clock = Optional.of(controlledClock);
        } else {
            this.clock = Optional.empty();
            this.service = System::currentTimeMillis;
        }
    }

    @Bean
    public Optional<ActorClock> getClock() {
        return this.clock;
    }

    @Bean
    public ActorClockService getClockService() {
        return this.service;
    }
}

