/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared.management;

import io.camunda.zeebe.gateway.admin.exporting.ExportingControlApi;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.stereotype.Component;

@Component
@WebEndpoint(id="exporting")
public final class ExportingEndpoint {
    static final String PAUSE = "pause";
    static final String RESUME = "resume";
    final ExportingControlApi exportingService;

    @Autowired
    public ExportingEndpoint(ExportingControlApi exportingService) {
        this.exportingService = exportingService;
    }

    @WriteOperation
    public WebEndpointResponse<?> post(@Selector(match=Selector.Match.SINGLE) String operationKey) {
        try {
            CompletableFuture result = switch (operationKey) {
                case PAUSE -> this.exportingService.pauseExporting();
                case RESUME -> this.exportingService.resumeExporting();
                default -> throw new UnsupportedOperationException();
            };
            result.join();
            return new WebEndpointResponse(204);
        }
        catch (CompletionException e) {
            return new WebEndpointResponse((Object)e.getCause(), 500);
        }
        catch (Exception e) {
            return new WebEndpointResponse((Object)e, 500);
        }
    }
}

