/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3;

import java.time.Duration;
import java.util.Optional;

public record S3BackupConfig(String bucketName, Optional<String> endpoint, Optional<String> region, Optional<Credentials> credentials, Optional<Duration> apiCallTimeout) {
    public S3BackupConfig(String bucketName) {
        this(bucketName, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static S3BackupConfig from(String bucketName, String endpoint, String region, String accessKey, String secretKey, Duration apiCallTimeoutMs) {
        Credentials credentials = null;
        if (accessKey != null && secretKey != null) {
            credentials = new Credentials(accessKey, secretKey);
        }
        return new S3BackupConfig(bucketName, Optional.ofNullable(endpoint), Optional.ofNullable(region), Optional.ofNullable(credentials), Optional.ofNullable(apiCallTimeoutMs));
    }

    record Credentials(String accessKey, String secretKey) {
        @Override
        public String toString() {
            return "Credentials{accessKey='" + this.accessKey + "', secretKey='<redacted>'}";
        }
    }
}

