/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3.manifest;

import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.common.BackupDescriptorImpl;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.common.BackupStatusImpl;
import io.camunda.zeebe.backup.s3.manifest.FailedBackupManifest;
import io.camunda.zeebe.backup.s3.manifest.ValidBackupManifest;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;

public final class CompletedBackupManifest
extends Record
implements ValidBackupManifest {
    private final BackupIdentifierImpl id;
    private final BackupDescriptorImpl descriptor;
    private final Set<String> snapshotFileNames;
    private final Set<String> segmentFileNames;
    private final Instant createdAt;
    private final Instant modifiedAt;

    public CompletedBackupManifest(BackupIdentifierImpl id, BackupDescriptorImpl descriptor, Set<String> snapshotFileNames, Set<String> segmentFileNames, Instant createdAt, Instant modifiedAt) {
        this.id = id;
        this.descriptor = descriptor;
        this.snapshotFileNames = snapshotFileNames;
        this.segmentFileNames = segmentFileNames;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
    }

    @Override
    public BackupStatusCode statusCode() {
        return BackupStatusCode.COMPLETED;
    }

    @Override
    public BackupStatus toStatus() {
        return new BackupStatusImpl((BackupIdentifier)this.id, Optional.of(this.descriptor), this.statusCode(), Optional.empty(), Optional.of(this.createdAt), Optional.of(this.modifiedAt));
    }

    @Override
    public FailedBackupManifest asFailed(String failureReason) {
        return new FailedBackupManifest(this.id, Optional.of(this.descriptor), failureReason, this.snapshotFileNames, this.segmentFileNames, this.createdAt, Instant.now());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CompletedBackupManifest.class, "id;descriptor;snapshotFileNames;segmentFileNames;createdAt;modifiedAt", "id", "descriptor", "snapshotFileNames", "segmentFileNames", "createdAt", "modifiedAt"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CompletedBackupManifest.class, "id;descriptor;snapshotFileNames;segmentFileNames;createdAt;modifiedAt", "id", "descriptor", "snapshotFileNames", "segmentFileNames", "createdAt", "modifiedAt"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CompletedBackupManifest.class, "id;descriptor;snapshotFileNames;segmentFileNames;createdAt;modifiedAt", "id", "descriptor", "snapshotFileNames", "segmentFileNames", "createdAt", "modifiedAt"}, this, o);
    }

    public BackupIdentifierImpl id() {
        return this.id;
    }

    public BackupDescriptorImpl descriptor() {
        return this.descriptor;
    }

    public Set<String> snapshotFileNames() {
        return this.snapshotFileNames;
    }

    public Set<String> segmentFileNames() {
        return this.segmentFileNames;
    }

    @Override
    public Instant createdAt() {
        return this.createdAt;
    }

    @Override
    public Instant modifiedAt() {
        return this.modifiedAt;
    }
}

