/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3.manifest;

import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.common.BackupDescriptorImpl;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.common.BackupStatusImpl;
import io.camunda.zeebe.backup.s3.manifest.ValidBackupManifest;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class FailedBackupManifest
extends Record
implements ValidBackupManifest {
    private final BackupIdentifierImpl id;
    private final Optional<BackupDescriptorImpl> descriptor;
    private final String failureReason;
    private final Set<String> snapshotFileNames;
    private final Set<String> segmentFileNames;
    private final Instant createdAt;
    private final Instant modifiedAt;

    public FailedBackupManifest(BackupIdentifierImpl id, Optional<BackupDescriptorImpl> descriptor, String failureReason, Set<String> snapshotFileNames, Set<String> segmentFileNames, Instant createdAt, Instant modifiedAt) {
        this.id = id;
        this.descriptor = descriptor;
        this.failureReason = failureReason;
        this.snapshotFileNames = snapshotFileNames;
        this.segmentFileNames = segmentFileNames;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
    }

    @Override
    public BackupStatusCode statusCode() {
        return BackupStatusCode.FAILED;
    }

    @Override
    public BackupStatus toStatus() {
        return new BackupStatusImpl((BackupIdentifier)this.id, this.descriptor.map(Function.identity()), this.statusCode(), Optional.of(this.failureReason), Optional.of(this.createdAt), Optional.of(this.modifiedAt));
    }

    @Override
    public FailedBackupManifest asFailed(String failureReason) {
        return this;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FailedBackupManifest.class, "id;descriptor;failureReason;snapshotFileNames;segmentFileNames;createdAt;modifiedAt", "id", "descriptor", "failureReason", "snapshotFileNames", "segmentFileNames", "createdAt", "modifiedAt"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FailedBackupManifest.class, "id;descriptor;failureReason;snapshotFileNames;segmentFileNames;createdAt;modifiedAt", "id", "descriptor", "failureReason", "snapshotFileNames", "segmentFileNames", "createdAt", "modifiedAt"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FailedBackupManifest.class, "id;descriptor;failureReason;snapshotFileNames;segmentFileNames;createdAt;modifiedAt", "id", "descriptor", "failureReason", "snapshotFileNames", "segmentFileNames", "createdAt", "modifiedAt"}, this, o);
    }

    public BackupIdentifierImpl id() {
        return this.id;
    }

    public Optional<BackupDescriptorImpl> descriptor() {
        return this.descriptor;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Set<String> snapshotFileNames() {
        return this.snapshotFileNames;
    }

    public Set<String> segmentFileNames() {
        return this.segmentFileNames;
    }

    @Override
    public Instant createdAt() {
        return this.createdAt;
    }

    @Override
    public Instant modifiedAt() {
        return this.modifiedAt;
    }
}

