/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.s3.manifest;

import io.camunda.zeebe.backup.api.Backup;
import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.s3.S3BackupStoreException;
import io.camunda.zeebe.backup.s3.manifest.CompletedBackupManifest;
import io.camunda.zeebe.backup.s3.manifest.FailedBackupManifest;
import io.camunda.zeebe.backup.s3.manifest.InProgressBackupManifest;
import io.camunda.zeebe.backup.s3.manifest.NoBackupManifest;
import java.io.PrintWriter;
import java.io.StringWriter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Manifest {
    public BackupIdentifier id();

    public BackupStatusCode statusCode();

    public BackupStatus toStatus();

    default public FailedBackupManifest asFailed(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return this.asFailed(writer.toString());
    }

    public FailedBackupManifest asFailed(String var1);

    public static InProgressBackupManifest fromNewBackup(Backup backup) {
        return new NoBackupManifest(BackupIdentifierImpl.from((BackupIdentifier)backup.id())).asInProgress(backup);
    }

    public static NoBackupManifest expectNoBackup(Manifest manifest) {
        if (manifest instanceof NoBackupManifest) {
            NoBackupManifest noBackup = (NoBackupManifest)manifest;
            return noBackup;
        }
        throw new S3BackupStoreException.BackupInInvalidStateException(manifest, BackupStatusCode.DOES_NOT_EXIST);
    }

    public static InProgressBackupManifest expectInProgress(Manifest manifest) {
        if (manifest instanceof InProgressBackupManifest) {
            InProgressBackupManifest inProgress = (InProgressBackupManifest)manifest;
            return inProgress;
        }
        throw new S3BackupStoreException.BackupInInvalidStateException(manifest, BackupStatusCode.IN_PROGRESS);
    }

    public static CompletedBackupManifest expectCompleted(Manifest manifest) {
        if (manifest instanceof CompletedBackupManifest) {
            CompletedBackupManifest completed = (CompletedBackupManifest)manifest;
            return completed;
        }
        throw new S3BackupStoreException.BackupInInvalidStateException(manifest, BackupStatusCode.COMPLETED);
    }
}

