/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.retry;

import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.retry.ActorRetryMechanism;
import io.camunda.zeebe.scheduler.retry.OperationToRetry;
import io.camunda.zeebe.scheduler.retry.RetryStrategy;
import java.util.function.BooleanSupplier;

public final class AbortableRetryStrategy
implements RetryStrategy {
    private final ActorControl actor;
    private final ActorRetryMechanism retryMechanism;
    private CompletableActorFuture<Boolean> currentFuture;

    public AbortableRetryStrategy(ActorControl actor) {
        this.actor = actor;
        this.retryMechanism = new ActorRetryMechanism();
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable) {
        return this.runWithRetry(callable, () -> false);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable, BooleanSupplier condition) {
        this.currentFuture = new CompletableActorFuture();
        this.retryMechanism.wrap(callable, condition, this.currentFuture);
        this.actor.run(this::run);
        return this.currentFuture;
    }

    private void run() {
        try {
            ActorRetryMechanism.Control control = this.retryMechanism.run();
            if (control == ActorRetryMechanism.Control.RETRY) {
                this.actor.run(this::run);
                this.actor.yieldThread();
            }
        }
        catch (Exception exception) {
            this.currentFuture.completeExceptionally(exception);
        }
    }
}

