/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitorActor;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.LongSupplier;

class DiskSpaceUsageMonitorStep
extends AbstractBrokerStartupStep {
    DiskSpaceUsageMonitorStep() {
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        DataCfg data = brokerStartupContext.getBrokerConfiguration().getData();
        if (!data.isDiskUsageMonitoringEnabled()) {
            brokerStartupContext.setDiskSpaceUsageMonitor(new DisabledDiskUsageMonitor());
            startupFuture.complete((Object)brokerStartupContext);
            return;
        }
        DiskSpaceUsageMonitorStep.startDiskUsageMonitorActor(brokerStartupContext, startupFuture, data);
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        if (brokerShutdownContext.getDiskSpaceUsageMonitor() == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        concurrencyControl.runOnCompletion(brokerShutdownContext.getDiskSpaceUsageMonitor().closeAsync(), (ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
                return;
            }
            this.forwardExceptions(() -> concurrencyControl.run(() -> this.forwardExceptions(() -> {
                brokerShutdownContext.setDiskSpaceUsageMonitor(null);
                shutdownFuture.complete((Object)brokerShutdownContext);
            }, shutdownFuture)), shutdownFuture);
        });
    }

    private static void startDiskUsageMonitorActor(BrokerStartupContext brokerStartupContext, ActorFuture<BrokerStartupContext> startupFuture, DataCfg data) {
        try {
            FileUtil.ensureDirectoryExists((Path)Paths.get(data.getDirectory(), new String[0]));
        }
        catch (IOException e) {
            startupFuture.completeExceptionally((Throwable)e);
            return;
        }
        DiskSpaceUsageMonitorActor diskSpaceUsageMonitor = new DiskSpaceUsageMonitorActor(data);
        ActorFuture actorStartFuture = brokerStartupContext.getActorSchedulingService().submitActor((Actor)diskSpaceUsageMonitor);
        brokerStartupContext.getConcurrencyControl().runOnCompletion(actorStartFuture, (ok, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
                return;
            }
            brokerStartupContext.setDiskSpaceUsageMonitor(diskSpaceUsageMonitor);
            startupFuture.complete((Object)brokerStartupContext);
        });
    }

    public String getName() {
        return "Disk Space Usage Monitor";
    }

    private static final class DisabledDiskUsageMonitor
    implements DiskSpaceUsageMonitor {
        private DisabledDiskUsageMonitor() {
        }

        @Override
        public void addDiskUsageListener(DiskSpaceUsageListener listener) {
        }

        @Override
        public void removeDiskUsageListener(DiskSpaceUsageListener listener) {
        }

        @Override
        public void setFreeDiskSpaceSupplier(LongSupplier freeDiskSpaceSupplier) {
        }

        public ActorFuture<Void> closeAsync() {
            return CompletableActorFuture.completed(null);
        }
    }
}

