/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.ActorFutureCollector;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

final class MultiPartitionAdminAccess
implements PartitionAdminAccess {
    private final ConcurrencyControl concurrencyControl;
    private final Map<Integer, ? extends PartitionAdminAccess> partitions;

    MultiPartitionAdminAccess(ConcurrencyControl concurrencyControl, Map<Integer, ? extends PartitionAdminAccess> partitions) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
        this.partitions = Collections.unmodifiableMap(Objects.requireNonNull(partitions));
    }

    @Override
    public Optional<PartitionAdminAccess> forPartition(int partitionId) {
        return Optional.ofNullable(this.partitions.get(partitionId));
    }

    @Override
    public ActorFuture<Void> takeSnapshot() {
        return this.callOnEachPartition(PartitionAdminAccess::takeSnapshot);
    }

    @Override
    public ActorFuture<Void> pauseExporting() {
        return this.callOnEachPartition(PartitionAdminAccess::pauseExporting);
    }

    @Override
    public ActorFuture<Void> resumeExporting() {
        return this.callOnEachPartition(PartitionAdminAccess::resumeExporting);
    }

    @Override
    public ActorFuture<Void> pauseProcessing() {
        return this.callOnEachPartition(PartitionAdminAccess::pauseProcessing);
    }

    @Override
    public ActorFuture<Void> resumeProcessing() {
        return this.callOnEachPartition(PartitionAdminAccess::resumeProcessing);
    }

    @Override
    public ActorFuture<Void> banInstance(long processInstanceKey) {
        int partitionId = Protocol.decodePartitionId((long)processInstanceKey);
        PartitionAdminAccess partition = this.partitions.get(partitionId);
        if (partition == null) {
            return CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Could not ban process instance %s, partition %s does not exist".formatted(processInstanceKey, partitionId)));
        }
        return partition.banInstance(processInstanceKey);
    }

    private ActorFuture<Void> callOnEachPartition(Function<PartitionAdminAccess, ActorFuture<Void>> functionToCall) {
        ActorFuture response = this.concurrencyControl.createFuture();
        ActorFuture aggregatedResult = (ActorFuture)this.partitions.values().stream().map(functionToCall).collect(new ActorFutureCollector(this.concurrencyControl));
        this.concurrencyControl.runOnCompletion(aggregatedResult, (value, error) -> {
            if (error != null) {
                response.completeExceptionally(error);
            } else {
                response.complete(null);
            }
        });
        return response;
    }
}

