/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.clustering.ClusterServices;
import io.camunda.zeebe.broker.engine.impl.LongPollingJobNotification;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.logstreams.state.StatePositionSupplier;
import io.camunda.zeebe.broker.partitioning.topology.TopologyManager;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConsistencyCheckCfg;
import io.camunda.zeebe.broker.system.configuration.RocksdbCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.StateController;
import io.camunda.zeebe.broker.system.partitions.TypedRecordProcessorsFactory;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.broker.system.partitions.impl.AtomixPartitionMessagingService;
import io.camunda.zeebe.broker.system.partitions.impl.AtomixRecordEntrySupplierImpl;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionProcessingState;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionTransitionImpl;
import io.camunda.zeebe.broker.system.partitions.impl.StateControllerImpl;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupApiRequestHandlerStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupServiceTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupStoreTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ExporterDirectorPartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.InterPartitionCommandServiceStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LogStoragePartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LogStreamPartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.QueryServicePartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.RockDbMetricExporterPartitionStartupStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.SnapshotDirectorPartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.StreamProcessorTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ZeebeDbPartitionTransitionStep;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiService;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.db.impl.rocksdb.ZeebeRocksDbFactory;
import io.camunda.zeebe.engine.api.InterPartitionCommandSender;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStoreFactory;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.FeatureFlags;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

final class PartitionFactory {
    private static final List<StartupStep<PartitionStartupContext>> STARTUP_STEPS = List.of(new RockDbMetricExporterPartitionStartupStep());
    private static final List<PartitionTransitionStep> TRANSITION_STEPS = List.of(new LogStoragePartitionTransitionStep(), new LogStreamPartitionTransitionStep(), new ZeebeDbPartitionTransitionStep(), new QueryServicePartitionTransitionStep(), new BackupStoreTransitionStep(), new BackupServiceTransitionStep(), new InterPartitionCommandServiceStep(), new StreamProcessorTransitionStep(), new SnapshotDirectorPartitionTransitionStep(), new ExporterDirectorPartitionTransitionStep(), new BackupApiRequestHandlerStep());
    private final ActorSchedulingService actorSchedulingService;
    private final BrokerCfg brokerCfg;
    private final BrokerInfo localBroker;
    private final CommandApiService commandApiService;
    private final FileBasedSnapshotStoreFactory snapshotStoreFactory;
    private final ClusterServices clusterServices;
    private final ExporterRepository exporterRepository;
    private final BrokerHealthCheckService healthCheckService;
    private final DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private final AtomixServerTransport gatewayBrokerTransport;

    PartitionFactory(ActorSchedulingService actorSchedulingService, BrokerCfg brokerCfg, BrokerInfo localBroker, CommandApiService commandApiService, FileBasedSnapshotStoreFactory snapshotStoreFactory, ClusterServices clusterServices, ExporterRepository exporterRepository, BrokerHealthCheckService healthCheckService, DiskSpaceUsageMonitor diskSpaceUsageMonitor, AtomixServerTransport gatewayBrokerTransport) {
        this.actorSchedulingService = actorSchedulingService;
        this.brokerCfg = brokerCfg;
        this.localBroker = localBroker;
        this.commandApiService = commandApiService;
        this.snapshotStoreFactory = snapshotStoreFactory;
        this.clusterServices = clusterServices;
        this.exporterRepository = exporterRepository;
        this.healthCheckService = healthCheckService;
        this.diskSpaceUsageMonitor = diskSpaceUsageMonitor;
        this.gatewayBrokerTransport = gatewayBrokerTransport;
    }

    List<ZeebePartition> constructPartitions(RaftPartitionGroup partitionGroup, List<PartitionListener> partitionListeners, TopologyManager topologyManager, FeatureFlags featureFlags) {
        ArrayList<ZeebePartition> partitions = new ArrayList<ZeebePartition>();
        ClusterCommunicationService communicationService = this.clusterServices.getCommunicationService();
        ClusterEventService eventService = this.clusterServices.getEventService();
        ClusterMembershipService membershipService = this.clusterServices.getMembershipService();
        MemberId nodeId = membershipService.getLocalMember().id();
        List<RaftPartition> owningPartitions = partitionGroup.getPartitionsWithMember(nodeId).stream().map(RaftPartition.class::cast).toList();
        TypedRecordProcessorsFactory typedRecordProcessorsFactory = this.createFactory(this.localBroker, eventService, featureFlags);
        for (RaftPartition owningPartition : owningPartitions) {
            Integer partitionId = (Integer)owningPartition.id().id();
            ConstructableSnapshotStore constructableSnapshotStore = this.snapshotStoreFactory.getConstructableSnapshotStore(partitionId.intValue());
            StateController stateController = this.createStateController(owningPartition, constructableSnapshotStore, this.snapshotStoreFactory.getSnapshotStoreConcurrencyControl(partitionId.intValue()));
            PartitionStartupAndTransitionContextImpl partitionStartupAndTransitionContext = new PartitionStartupAndTransitionContextImpl(this.localBroker.getNodeId(), communicationService, owningPartition, partitionListeners, new AtomixPartitionMessagingService(communicationService, membershipService, owningPartition.members()), this.actorSchedulingService, this.brokerCfg, this.commandApiService::newCommandResponseWriter, () -> this.commandApiService.getOnProcessedListener(partitionId), (PersistedSnapshotStore)constructableSnapshotStore, stateController, typedRecordProcessorsFactory, this.exporterRepository, new PartitionProcessingState(owningPartition), this.diskSpaceUsageMonitor, this.gatewayBrokerTransport, topologyManager);
            PartitionTransitionImpl newTransitionBehavior = new PartitionTransitionImpl(TRANSITION_STEPS);
            ZeebePartition zeebePartition = new ZeebePartition(partitionStartupAndTransitionContext, newTransitionBehavior, STARTUP_STEPS);
            this.healthCheckService.registerMonitoredPartition(zeebePartition.getPartitionId(), zeebePartition);
            partitions.add(zeebePartition);
        }
        return partitions;
    }

    private StateController createStateController(RaftPartition raftPartition, ConstructableSnapshotStore snapshotStore, ConcurrencyControl concurrencyControl) {
        Path runtimeDirectory = raftPartition.dataDirectory().toPath().resolve("runtime");
        RocksdbCfg databaseCfg = this.brokerCfg.getExperimental().getRocksdb();
        ConsistencyCheckCfg consistencyChecks = this.brokerCfg.getExperimental().getConsistencyChecks();
        return new StateControllerImpl((ZeebeDbFactory)new ZeebeRocksDbFactory(databaseCfg.createRocksDbConfiguration(), consistencyChecks.getSettings()), snapshotStore, runtimeDirectory, new AtomixRecordEntrySupplierImpl(raftPartition.getServer()), StatePositionSupplier::getHighestExportedPosition, concurrencyControl);
    }

    private TypedRecordProcessorsFactory createFactory(BrokerInfo localBroker, ClusterEventService eventService, FeatureFlags featureFlags) {
        return recordProcessorContext -> {
            InterPartitionCommandSender partitionCommandSender = recordProcessorContext.getPartitionCommandSender();
            SubscriptionCommandSender subscriptionCommandSender = new SubscriptionCommandSender(recordProcessorContext.getPartitionId(), partitionCommandSender);
            DeploymentDistributionCommandSender deploymentDistributionCommandSender = new DeploymentDistributionCommandSender(recordProcessorContext.getPartitionId(), partitionCommandSender);
            LongPollingJobNotification jobsAvailableNotification = new LongPollingJobNotification(eventService);
            return EngineProcessors.createEngineProcessors((TypedRecordProcessorContext)recordProcessorContext, (int)localBroker.getPartitionsCount(), (SubscriptionCommandSender)subscriptionCommandSender, (DeploymentDistributionCommandSender)deploymentDistributionCommandSender, jobsAvailableNotification::onJobsAvailable, (FeatureFlags)featureFlags);
        };
    }
}

