/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.protocol;

import io.camunda.zeebe.broker.protocol.ExporterPositionsDecoder;
import io.camunda.zeebe.broker.protocol.MessageHeaderEncoder;
import io.camunda.zeebe.broker.protocol.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class ExporterPositionsEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 2;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ExporterPositionsEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final PositionsEncoder positions = new PositionsEncoder(this);

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ExporterPositionsEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 0);
        return this;
    }

    public ExporterPositionsEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(0).templateId(1).schemaId(5).version(2);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long positionsId() {
        return 0L;
    }

    public PositionsEncoder positionsCount(int count) {
        this.positions.wrap(this.buffer, count);
        return this.positions;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ExporterPositionsDecoder decoder = new ExporterPositionsDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 0, 2);
        return decoder.appendTo(builder);
    }

    public static final class PositionsEncoder {
        public static final int HEADER_SIZE = 3;
        private final ExporterPositionsEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PositionsEncoder(ExporterPositionsEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)8, ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public PositionsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + PositionsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public static int positionId() {
            return 0;
        }

        public static int positionSinceVersion() {
            return 0;
        }

        public static int positionEncodingOffset() {
            return 0;
        }

        public static int positionEncodingLength() {
            return 8;
        }

        public static String positionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
                return "long";
            }
            return "";
        }

        public static long positionNullValue() {
            return -1L;
        }

        public static long positionMinValue() {
            return 0L;
        }

        public static long positionMaxValue() {
            return -2L;
        }

        public PositionsEncoder position(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int exporterIdId() {
            return 1;
        }

        public static String exporterIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String exporterIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
                return "string";
            }
            return "";
        }

        public static int exporterIdHeaderLength() {
            return 4;
        }

        public PositionsEncoder putExporterId(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PositionsEncoder putExporterId(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public PositionsEncoder exporterId(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }
}

