/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.protocol;

import io.camunda.zeebe.broker.protocol.MessageHeaderDecoder;
import io.camunda.zeebe.broker.protocol.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class InterPartitionMessageDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 2;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final InterPartitionMessageDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 4;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public InterPartitionMessageDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public InterPartitionMessageDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (4 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public InterPartitionMessageDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int receiverPartitionIdId() {
        return 0;
    }

    public static int receiverPartitionIdSinceVersion() {
        return 0;
    }

    public static int receiverPartitionIdEncodingOffset() {
        return 0;
    }

    public static int receiverPartitionIdEncodingLength() {
        return 2;
    }

    public static String receiverPartitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int receiverPartitionIdNullValue() {
        return 65535;
    }

    public static int receiverPartitionIdMinValue() {
        return 0;
    }

    public static int receiverPartitionIdMaxValue() {
        return 65534;
    }

    public int receiverPartitionId() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int valueTypeId() {
        return 1;
    }

    public static int valueTypeSinceVersion() {
        return 0;
    }

    public static int valueTypeEncodingOffset() {
        return 2;
    }

    public static int valueTypeEncodingLength() {
        return 1;
    }

    public static String valueTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short valueTypeNullValue() {
        return 255;
    }

    public static short valueTypeMinValue() {
        return 0;
    }

    public static short valueTypeMaxValue() {
        return 254;
    }

    public short valueType() {
        return (short)(this.buffer.getByte(this.offset + 2) & 0xFF);
    }

    public static int intentId() {
        return 2;
    }

    public static int intentSinceVersion() {
        return 0;
    }

    public static int intentEncodingOffset() {
        return 3;
    }

    public static int intentEncodingLength() {
        return 1;
    }

    public static String intentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short intentNullValue() {
        return 255;
    }

    public static short intentMinValue() {
        return 0;
    }

    public static short intentMaxValue() {
        return 254;
    }

    public short intent() {
        return (short)(this.buffer.getByte(this.offset + 3) & 0xFF);
    }

    public static int recordKeyId() {
        return 3;
    }

    public static int recordKeySinceVersion() {
        return 0;
    }

    public static int recordKeyEncodingOffset() {
        return 4;
    }

    public static int recordKeyEncodingLength() {
        return 8;
    }

    public static String recordKeyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long recordKeyNullValue() {
        return -1L;
    }

    public static long recordKeyMinValue() {
        return 0L;
    }

    public static long recordKeyMaxValue() {
        return -2L;
    }

    public long recordKey() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int checkpointIdId() {
        return 4;
    }

    public static int checkpointIdSinceVersion() {
        return 0;
    }

    public static int checkpointIdEncodingOffset() {
        return 12;
    }

    public static int checkpointIdEncodingLength() {
        return 8;
    }

    public static String checkpointIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long checkpointIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long checkpointIdMinValue() {
        return -9223372036854775807L;
    }

    public static long checkpointIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long checkpointId() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int commandId() {
        return 32;
    }

    public static int commandSinceVersion() {
        return 0;
    }

    public static String commandCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String commandMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int commandHeaderLength() {
        return 4;
    }

    public int commandLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipCommand() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getCommand(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getCommand(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapCommand(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String command() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        InterPartitionMessageDecoder decoder = new InterPartitionMessageDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[InterPartitionMessage](sbeTemplateId=");
        builder.append(4);
        builder.append("|sbeSchemaId=");
        builder.append(5);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 2) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(2);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 20) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(20);
        builder.append("):");
        builder.append("receiverPartitionId=");
        builder.append(this.receiverPartitionId());
        builder.append('|');
        builder.append("valueType=");
        builder.append(this.valueType());
        builder.append('|');
        builder.append("intent=");
        builder.append(this.intent());
        builder.append('|');
        builder.append("recordKey=");
        builder.append(this.recordKey());
        builder.append('|');
        builder.append("checkpointId=");
        builder.append(this.checkpointId());
        builder.append('|');
        builder.append("command=");
        builder.append('\'').append(this.command()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public InterPartitionMessageDecoder sbeSkip() {
        this.sbeRewind();
        this.skipCommand();
        return this;
    }
}

