/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.engine;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.engine.CachesCfg;
import io.camunda.zeebe.broker.system.configuration.engine.MessagesCfg;
import io.camunda.zeebe.engine.EngineConfiguration;

public final class EngineCfg
implements ConfigurationEntry {
    private MessagesCfg messages = new MessagesCfg();
    private CachesCfg caches = new CachesCfg();

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.messages.init(globalConfig, brokerBase);
        this.caches.init(globalConfig, brokerBase);
    }

    public MessagesCfg getMessages() {
        return this.messages;
    }

    public void setMessages(MessagesCfg messages) {
        this.messages = messages;
    }

    public CachesCfg getCaches() {
        return this.caches;
    }

    public void setCaches(CachesCfg caches) {
        this.caches = caches;
    }

    public String toString() {
        return "EngineCfg{messages=" + this.messages + ", caches=" + this.caches + "}";
    }

    public EngineConfiguration createEngineConfiguration() {
        return new EngineConfiguration().setMessagesTtlCheckerBatchLimit(this.messages.getTtlCheckerBatchLimit()).setMessagesTtlCheckerInterval(this.messages.getTtlCheckerInterval()).setDrgCacheCapacity(this.caches.getDrgCacheCapacity());
    }
}

