/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.broker.system.partitions.PartitionAdminControl;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.api.records.RecordBatchEntry;
import io.camunda.zeebe.engine.state.processing.DbBannedInstanceState;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

class ZeebePartitionAdminAccess
implements PartitionAdminAccess {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final ConcurrencyControl concurrencyControl;
    private final int partitionId;
    private final PartitionAdminControl adminControl;

    ZeebePartitionAdminAccess(ConcurrencyControl concurrencyControl, int partitionId, PartitionAdminControl adminControl) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
        this.partitionId = partitionId;
        this.adminControl = Objects.requireNonNull(adminControl);
    }

    @Override
    public Optional<PartitionAdminAccess> forPartition(int partitionId) {
        if (this.partitionId == partitionId) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public ActorFuture<Void> takeSnapshot() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.triggerSnapshot();
                completed.complete(null);
            }
            catch (Exception e) {
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> pauseExporting() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                boolean pauseStatePersisted = this.adminControl.pauseExporting();
                if (this.adminControl.getExporterDirector() != null && pauseStatePersisted) {
                    this.adminControl.getExporterDirector().pauseExporting().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not pause exporting", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> resumeExporting() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.resumeExporting();
                if (this.adminControl.getExporterDirector() != null && this.adminControl.shouldExport()) {
                    this.adminControl.getExporterDirector().resumeExporting().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not resume exporting", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> pauseProcessing() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.pauseProcessing();
                if (this.adminControl.getStreamProcessor() != null && !this.adminControl.shouldProcess()) {
                    this.adminControl.getStreamProcessor().pauseProcessing().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not pause processing state", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> resumeProcessing() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.resumeProcessing();
                if (this.adminControl.getStreamProcessor() != null && this.adminControl.shouldProcess()) {
                    this.adminControl.getStreamProcessor().resumeProcessing();
                }
                completed.complete(null);
            }
            catch (IOException e) {
                LOG.error("Could not resume processing", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> banInstance(long processInstanceKey) {
        ActorFuture future = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.getLogStream().newLogStreamRecordWriter().onComplete((writer, error) -> {
                    if (error != null) {
                        LOG.error("Could not retrieve writer to write error record for process instance.", error);
                        future.completeExceptionally(error);
                        return;
                    }
                    this.writeErrorEventAndBanInstance(processInstanceKey, (LogStreamRecordWriter)writer, (ActorFuture<Void>)future);
                });
            }
            catch (Exception e) {
                LOG.error("Failure on writing error record to ban instance {} onto the LogStream.", (Object)processInstanceKey, (Object)e);
                future.completeExceptionally((Throwable)e);
            }
        });
        return future;
    }

    private void writeErrorEventAndBanInstance(long processInstanceKey, LogStreamRecordWriter writer, ActorFuture<Void> future) {
        long position = ZeebePartitionAdminAccess.tryWriteErrorEvent(writer, processInstanceKey);
        if (position >= 0L) {
            LOG.info("Wrote error record on position {}", (Object)position);
            this.banInstanceInState(processInstanceKey);
            LOG.info("Successfully banned instance with key {}", (Object)processInstanceKey);
            future.complete(null);
        } else {
            String errorMsg = String.format("Failure on writing error record to ban instance %d", processInstanceKey);
            future.completeExceptionally((Throwable)new IllegalStateException(errorMsg));
            LOG.error(errorMsg);
        }
    }

    private void banInstanceInState(long processInstanceKey) {
        ZeebeDb zeebeDb = this.adminControl.getZeebeDb();
        TransactionContext context = zeebeDb.createContext();
        DbBannedInstanceState dbBannedInstanceState = new DbBannedInstanceState(zeebeDb, context, this.partitionId);
        dbBannedInstanceState.banProcessInstance(processInstanceKey);
    }

    private static long tryWriteErrorEvent(LogStreamRecordWriter writer, long processInstanceKey) {
        ErrorRecord errorRecord = new ErrorRecord();
        errorRecord.initErrorRecord((Throwable)new Exception("Instance was banned from outside."), -1L);
        errorRecord.setProcessInstanceKey(processInstanceKey);
        RecordMetadata recordMetadata = new RecordMetadata().recordType(RecordType.EVENT).valueType(ValueType.ERROR).intent((Intent)ErrorIntent.CREATED).rejectionType(RejectionType.NULL_VAL).rejectionReason("");
        RecordBatchEntry entry = RecordBatchEntry.createEntry((long)processInstanceKey, (int)-1, (RecordType)recordMetadata.getRecordType(), (Intent)recordMetadata.getIntent(), (RejectionType)recordMetadata.getRejectionType(), (String)recordMetadata.getRejectionReason(), (ValueType)recordMetadata.getValueType(), (BufferWriter)errorRecord);
        return writer.metadataWriter((BufferWriter)recordMetadata).valueWriter((BufferWriter)entry.recordValue()).key(processInstanceKey).tryWrite();
    }
}

