/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftCommittedEntryListener;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.camunda.zeebe.broker.system.partitions.NoEntryAtSnapshotPosition;
import io.camunda.zeebe.broker.system.partitions.StateController;
import io.camunda.zeebe.broker.system.partitions.impl.RandomDuration;
import io.camunda.zeebe.logstreams.impl.Loggers;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotException;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.streamprocessor.StreamProcessor;
import io.camunda.zeebe.streamprocessor.StreamProcessorMode;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthReport;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class AsyncSnapshotDirector
extends Actor
implements RaftCommittedEntryListener,
HealthMonitorable {
    public static final Duration MINIMUM_SNAPSHOT_PERIOD = Duration.ofMinutes(1L);
    private static final Logger LOG = Loggers.SNAPSHOT_LOGGER;
    private static final String LOG_MSG_WAIT_UNTIL_COMMITTED = "Finished taking temporary snapshot, need to wait until last written event position {} is committed, current commit position is {}. After that snapshot will be committed.";
    private static final String ERROR_MSG_ON_RESOLVE_PROCESSED_POS = "Unexpected error in resolving last processed position.";
    private static final String ERROR_MSG_ON_RESOLVE_WRITTEN_POS = "Unexpected error in resolving last written position.";
    private static final String ERROR_MSG_MOVE_SNAPSHOT = "Unexpected exception occurred on moving valid snapshot.";
    private final StateController stateController;
    private final Duration snapshotRate;
    private final String processorName;
    private final StreamProcessor streamProcessor;
    private final String actorName;
    private final StreamProcessorMode streamProcessorMode;
    private final Callable<CompletableFuture<Void>> flushLog;
    private final Set<FailureListener> listeners = new HashSet<FailureListener>();
    private final int partitionId;
    private final TreeMap<Long, ActorFuture<Void>> commitAwaiters = new TreeMap();
    private CompletableActorFuture<PersistedSnapshot> ongoingSnapshotFuture;
    private volatile HealthReport healthReport = HealthReport.healthy((HealthMonitorable)this);
    private long commitPosition;

    private AsyncSnapshotDirector(int partitionId, StreamProcessor streamProcessor, StateController stateController, Duration snapshotRate, StreamProcessorMode streamProcessorMode, Callable<CompletableFuture<Void>> flushLog) {
        this.streamProcessor = streamProcessor;
        this.stateController = stateController;
        this.processorName = streamProcessor.getName();
        this.snapshotRate = snapshotRate;
        this.partitionId = partitionId;
        this.actorName = AsyncSnapshotDirector.buildActorName((String)"SnapshotDirector", (int)this.partitionId);
        this.streamProcessorMode = streamProcessorMode;
        this.flushLog = flushLog;
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        Duration firstSnapshotTime = RandomDuration.getRandomDurationMinuteBased(MINIMUM_SNAPSHOT_PERIOD, this.snapshotRate);
        this.actor.runDelayed(firstSnapshotTime, this::scheduleSnapshotOnRate);
    }

    public ActorFuture<Void> closeAsync() {
        if (this.actor.isClosed()) {
            return CompletableActorFuture.completed(null);
        }
        return super.closeAsync();
    }

    protected void handleFailure(Throwable failure) {
        LOG.error("No snapshot was taken due to failure in '{}'. Will try to take snapshot after snapshot period {}. {}", new Object[]{this.actorName, this.snapshotRate, failure});
        this.resetStateOnFailure(failure);
        this.healthReport = HealthReport.unhealthy((HealthMonitorable)this).withIssue(failure);
        for (FailureListener listener : this.listeners) {
            listener.onFailure(this.healthReport);
        }
    }

    public static AsyncSnapshotDirector ofReplayMode(int nodeId, int partitionId, StreamProcessor streamProcessor, StateController stateController, Duration snapshotRate, Callable<CompletableFuture<Void>> flushLog) {
        return new AsyncSnapshotDirector(partitionId, streamProcessor, stateController, snapshotRate, StreamProcessorMode.REPLAY, flushLog);
    }

    public static AsyncSnapshotDirector ofProcessingMode(int nodeId, int partitionId, StreamProcessor streamProcessor, StateController stateController, Duration snapshotRate, Callable<CompletableFuture<Void>> flushLog) {
        return new AsyncSnapshotDirector(partitionId, streamProcessor, stateController, snapshotRate, StreamProcessorMode.PROCESSING, flushLog);
    }

    private void scheduleSnapshotOnRate() {
        this.actor.runAtFixedRate(this.snapshotRate, this::trySnapshot);
        this.trySnapshot();
    }

    public CompletableActorFuture<PersistedSnapshot> forceSnapshot() {
        CompletableActorFuture newSnapshotFuture = new CompletableActorFuture();
        this.actor.call(() -> this.trySnapshot().onComplete((BiConsumer)newSnapshotFuture));
        return newSnapshotFuture;
    }

    public HealthReport getHealthReport() {
        return this.healthReport;
    }

    public void addFailureListener(FailureListener listener) {
        this.actor.run(() -> this.listeners.add(listener));
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.listeners.remove(failureListener));
    }

    private ActorFuture<PersistedSnapshot> trySnapshot() {
        CompletableActorFuture snapshotFuture;
        if (this.ongoingSnapshotFuture != null) {
            LOG.debug("Already taking snapshot, skipping this request for a new snapshot");
            return CompletableActorFuture.completed(null);
        }
        this.ongoingSnapshotFuture = snapshotFuture = new CompletableActorFuture();
        InProgressSnapshot inProgressSnapshot = new InProgressSnapshot();
        this.streamProcessor.getLastProcessedPositionAsync().onComplete((position, error) -> {
            if (error != null) {
                LOG.error(ERROR_MSG_ON_RESOLVE_PROCESSED_POS, error);
                snapshotFuture.completeExceptionally(error);
            } else if (position == -1L) {
                LOG.debug("We will skip taking this snapshot, because we haven't processed anything yet.");
                snapshotFuture.complete(null);
            } else {
                inProgressSnapshot.lowerBoundSnapshotPosition = position;
                this.snapshot(inProgressSnapshot).onComplete((BiConsumer)snapshotFuture);
            }
        });
        snapshotFuture.onComplete((snapshot, snapshotError) -> {
            if (snapshotError != null && inProgressSnapshot.pendingSnapshot != null) {
                inProgressSnapshot.pendingSnapshot.abort();
            }
            this.ongoingSnapshotFuture = null;
        });
        return snapshotFuture;
    }

    private ActorFuture<PersistedSnapshot> snapshot(InProgressSnapshot inProgressSnapshot) {
        ActorFuture takeTransientSnapshotFuture = this.actor.createFuture();
        ActorFuture getLastWrittenPositionFuture = this.actor.createFuture();
        ActorFuture lastWrittenPositionCommittedFuture = this.actor.createFuture();
        ActorFuture journalFlushFuture = this.actor.createFuture();
        ActorFuture snapshotPersistedFuture = this.actor.createFuture();
        this.takeTransientSnapshot(inProgressSnapshot).onComplete((BiConsumer)takeTransientSnapshotFuture);
        takeTransientSnapshotFuture.onComplete(this.proceed(arg_0 -> ((ActorFuture)getLastWrittenPositionFuture).completeExceptionally(arg_0), () -> this.getLastWrittenPosition(inProgressSnapshot).onComplete((BiConsumer)getLastWrittenPositionFuture)));
        getLastWrittenPositionFuture.onComplete(this.proceed(arg_0 -> ((ActorFuture)lastWrittenPositionCommittedFuture).completeExceptionally(arg_0), () -> this.waitUntilLastWrittenPositionIsCommitted(inProgressSnapshot).onComplete((BiConsumer)lastWrittenPositionCommittedFuture)));
        lastWrittenPositionCommittedFuture.onComplete(this.proceed(arg_0 -> ((ActorFuture)journalFlushFuture).completeExceptionally(arg_0), () -> this.flushJournal().onComplete((BiConsumer)journalFlushFuture)));
        journalFlushFuture.onComplete(this.proceed(arg_0 -> ((ActorFuture)snapshotPersistedFuture).completeExceptionally(arg_0), () -> this.persistSnapshot(inProgressSnapshot).onComplete((BiConsumer)snapshotPersistedFuture)));
        return snapshotPersistedFuture;
    }

    private ActorFuture<Void> flushJournal() {
        CompletableActorFuture future = new CompletableActorFuture();
        try {
            this.flushLog.call().whenComplete((ignore, error) -> {
                if (error != null) {
                    LOG.warn("Failed to flush journal before committing snapshot", error);
                    future.completeExceptionally(error);
                } else {
                    future.complete(null);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Failed to flush journal before committing snapshot", (Throwable)e);
            future.completeExceptionally((Throwable)e);
        }
        return future;
    }

    private ActorFuture<PersistedSnapshot> persistSnapshot(InProgressSnapshot inProgressSnapshot) {
        ActorFuture snapshotPersisted = inProgressSnapshot.pendingSnapshot.withLastFollowupEventPosition(inProgressSnapshot.lastWrittenPosition).persist();
        snapshotPersisted.onComplete((snapshot, persistError) -> {
            if (persistError != null) {
                if (persistError instanceof SnapshotException.SnapshotNotFoundException) {
                    LOG.warn("Failed to persist transient snapshot {}. Nothing to worry if a newer snapshot exists.", (Object)inProgressSnapshot.pendingSnapshot, persistError);
                } else {
                    LOG.error(ERROR_MSG_MOVE_SNAPSHOT, persistError);
                }
            }
        });
        return snapshotPersisted;
    }

    private ActorFuture<Void> getLastWrittenPosition(InProgressSnapshot inProgressSnapshot) {
        CompletableActorFuture lastWrittenPositionReceived = new CompletableActorFuture();
        this.streamProcessor.getLastWrittenPositionAsync().onComplete((arg_0, arg_1) -> AsyncSnapshotDirector.lambda$getLastWrittenPosition$11((ActorFuture)lastWrittenPositionReceived, inProgressSnapshot, arg_0, arg_1));
        return lastWrittenPositionReceived;
    }

    private ActorFuture<Void> waitUntilLastWrittenPositionIsCommitted(InProgressSnapshot inProgressSnapshot) {
        if (this.streamProcessorMode == StreamProcessorMode.REPLAY || this.commitPosition >= inProgressSnapshot.lastWrittenPosition) {
            return CompletableActorFuture.completed(null);
        }
        LOG.info(LOG_MSG_WAIT_UNTIL_COMMITTED, (Object)inProgressSnapshot.lastWrittenPosition, (Object)this.commitPosition);
        return this.commitAwaiters.computeIfAbsent(inProgressSnapshot.lastWrittenPosition, k -> new CompletableActorFuture());
    }

    private ActorFuture<Void> takeTransientSnapshot(InProgressSnapshot inProgressSnapshot) {
        CompletableActorFuture snapshotTaken = new CompletableActorFuture();
        this.stateController.takeTransientSnapshot(inProgressSnapshot.lowerBoundSnapshotPosition).onComplete((arg_0, arg_1) -> this.lambda$takeTransientSnapshot$13((ActorFuture)snapshotTaken, inProgressSnapshot, arg_0, arg_1));
        return snapshotTaken;
    }

    void logSnapshotTakenError(Throwable snapshotTakenError) {
        if (snapshotTakenError instanceof SnapshotException.SnapshotAlreadyExistsException) {
            LOG.debug("Did not take a snapshot. {}", (Object)snapshotTakenError.getMessage());
        } else if (snapshotTakenError instanceof NoEntryAtSnapshotPosition && this.streamProcessorMode == StreamProcessorMode.REPLAY) {
            LOG.debug("Did not take a snapshot: {}. Most likely this partition has not received the entry yet. Will retry in {}", (Object)snapshotTakenError.getMessage(), (Object)this.snapshotRate);
        } else {
            LOG.error("Failed to take a snapshot for {}", (Object)this.processorName, (Object)snapshotTakenError);
        }
    }

    private void onRecovered() {
        if (!this.healthReport.isHealthy()) {
            this.healthReport = HealthReport.healthy((HealthMonitorable)this);
            this.listeners.forEach(FailureListener::onRecovered);
        }
    }

    public void onCommit(IndexedRaftLogEntry indexedRaftLogEntry) {
        if (indexedRaftLogEntry.isApplicationEntry()) {
            long committedPosition = indexedRaftLogEntry.getApplicationEntry().highestPosition();
            this.newPositionCommitted(committedPosition);
        }
    }

    public void newPositionCommitted(long currentCommitPosition) {
        this.actor.run(() -> {
            this.commitPosition = currentCommitPosition;
            NavigableMap<Long, ActorFuture<Void>> futuresToComplete = this.commitAwaiters.headMap(this.commitPosition, true);
            futuresToComplete.forEach((k, f) -> f.complete(null));
            futuresToComplete.clear();
        });
    }

    private void resetStateOnFailure(Throwable failure) {
        if (this.ongoingSnapshotFuture != null && !this.ongoingSnapshotFuture.isDone()) {
            this.ongoingSnapshotFuture.completeExceptionally(failure);
        }
        this.ongoingSnapshotFuture = null;
    }

    private BiConsumer<Void, Throwable> proceed(Consumer<Throwable> onError, Runnable nextStep) {
        return (ignore, error) -> {
            if (error != null) {
                onError.accept((Throwable)error);
            } else {
                nextStep.run();
            }
        };
    }

    private /* synthetic */ void lambda$takeTransientSnapshot$13(ActorFuture snapshotTaken, InProgressSnapshot inProgressSnapshot, TransientSnapshot snapshot, Throwable error) {
        if (error != null) {
            this.logSnapshotTakenError(error);
            snapshotTaken.completeExceptionally(error);
        } else {
            inProgressSnapshot.pendingSnapshot = snapshot;
            snapshotTaken.complete(null);
            this.onRecovered();
        }
    }

    private static /* synthetic */ void lambda$getLastWrittenPosition$11(ActorFuture lastWrittenPositionReceived, InProgressSnapshot inProgressSnapshot, Long position, Throwable error) {
        if (error != null) {
            LOG.error(ERROR_MSG_ON_RESOLVE_WRITTEN_POS, error);
            lastWrittenPositionReceived.completeExceptionally(error);
        } else {
            inProgressSnapshot.lastWrittenPosition = position;
            lastWrittenPositionReceived.complete(null);
        }
    }

    private static class InProgressSnapshot {
        private long lastWrittenPosition;
        private TransientSnapshot pendingSnapshot;
        private long lowerBoundSnapshotPosition;

        private InProgressSnapshot() {
        }
    }
}

