/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.backup.s3.S3BackupConfig;
import io.camunda.zeebe.backup.s3.S3BackupStore;
import io.camunda.zeebe.broker.system.configuration.backup.BackupStoreCfg;
import io.camunda.zeebe.broker.system.configuration.backup.S3BackupStoreConfig;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import java.time.Duration;

public final class BackupStoreTransitionStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        BackupStore backupStore = context.getBackupStore();
        if (backupStore != null && this.shouldCloseOnTransition(context.getCurrentRole(), targetRole)) {
            ActorFuture closed = context.getConcurrencyControl().createFuture();
            backupStore.closeAsync().thenAcceptAsync(ignore -> {
                context.setBackupStore(null);
                context.setCheckpointProcessor(null);
                closed.complete(null);
            }, arg_0 -> ((ConcurrencyControl)context.getConcurrencyControl()).run(arg_0));
            return closed;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        ActorFuture installed = context.getConcurrencyControl().createFuture();
        if (this.shouldInstallOnTransition(context.getCurrentRole(), targetRole) || context.getBackupStore() == null && targetRole != RaftServer.Role.INACTIVE) {
            boolean isBackupFeatureDisabled = !context.getBrokerCfg().getExperimental().getFeatures().isEnableBackup();
            BackupStoreCfg backupCfg = context.getBrokerCfg().getData().getBackup();
            if (backupCfg.getStore() == BackupStoreCfg.BackupStoreType.NONE || isBackupFeatureDisabled) {
                context.setBackupStore(null);
                installed.complete(null);
            } else if (backupCfg.getStore() == BackupStoreCfg.BackupStoreType.S3) {
                BackupStoreTransitionStep.installS3Store(context, backupCfg, (ActorFuture<Void>)installed);
            } else {
                installed.completeExceptionally((Throwable)new IllegalArgumentException("Unknown backup store type %s".formatted(new Object[]{backupCfg.getStore()})));
            }
        } else {
            installed.complete(null);
        }
        return installed;
    }

    @Override
    public String getName() {
        return "BackupStore";
    }

    private static void installS3Store(PartitionTransitionContext context, BackupStoreCfg backupCfg, ActorFuture<Void> installed) {
        try {
            S3BackupStoreConfig s3Config = backupCfg.getS3();
            S3BackupConfig storeConfig = S3BackupConfig.from((String)s3Config.getBucketName(), (String)s3Config.getEndpoint(), (String)s3Config.getRegion(), (String)s3Config.getAccessKey(), (String)s3Config.getSecretKey(), (Duration)s3Config.getApiCallTimeout());
            S3BackupStore backupStore = new S3BackupStore(storeConfig);
            context.setBackupStore((BackupStore)backupStore);
            installed.complete(null);
        }
        catch (Exception error) {
            installed.completeExceptionally("Failed to create backup store", (Throwable)error);
        }
    }

    private boolean shouldInstallOnTransition(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        return targetRole == RaftServer.Role.LEADER || targetRole == RaftServer.Role.FOLLOWER && currentRole != RaftServer.Role.CANDIDATE || targetRole == RaftServer.Role.CANDIDATE && currentRole != RaftServer.Role.FOLLOWER;
    }

    private boolean shouldCloseOnTransition(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        return this.shouldInstallOnTransition(currentRole, targetRole) || targetRole == RaftServer.Role.INACTIVE;
    }
}

