/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.backup.api.CheckpointListener;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.transport.partitionapi.InterPartitionCommandReceiverActor;
import io.camunda.zeebe.broker.transport.partitionapi.InterPartitionCommandSenderService;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;

public final class InterPartitionCommandServiceStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        ActorFuture closeFuture = context.getConcurrencyControl().createFuture();
        ActorFuture<Void> receiverClosed = this.closeReceiver(context);
        ActorFuture<Void> senderClosed = this.closeSender(context);
        receiverClosed.onComplete((ignore, error) -> {
            if (error != null) {
                closeFuture.completeExceptionally("Failed to close InterPartitionCommandReceiver", error);
            } else {
                this.waitForSenderToClose((ActorFuture<Void>)closeFuture, senderClosed);
            }
        });
        return closeFuture;
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (targetRole == RaftServer.Role.LEADER && context.getPartitionCommandReceiver() == null) {
            ActorFuture installFuture = context.getConcurrencyControl().createFuture();
            ActorFuture<Void> receiverInstalled = this.installReceiver(context);
            ActorFuture<Void> senderInstalled = this.installSender(context);
            receiverInstalled.onComplete((ignore, error) -> {
                if (error != null) {
                    installFuture.completeExceptionally("Failed to install InterPartitionCommandReceiver", error);
                } else {
                    this.waitForSenderToStart((ActorFuture<Void>)installFuture, senderInstalled);
                }
            });
            return installFuture;
        }
        return context.getConcurrencyControl().createCompletedFuture();
    }

    @Override
    public String getName() {
        return "InterPartitionCommandService";
    }

    private void completeAfterFuture(ActorFuture<Void> futureToComplete, ActorFuture<Void> futureToWait, String errorMessage) {
        futureToWait.onComplete((ok, senderError) -> {
            if (senderError != null) {
                futureToComplete.completeExceptionally(errorMessage, senderError);
            } else {
                futureToComplete.complete(null);
            }
        });
    }

    private void waitForSenderToClose(ActorFuture<Void> closeFuture, ActorFuture<Void> senderClosed) {
        this.completeAfterFuture(closeFuture, senderClosed, "Failed to close InterPartitionCommandSender");
    }

    private void waitForSenderToStart(ActorFuture<Void> startFuture, ActorFuture<Void> senderInstalled) {
        this.completeAfterFuture(startFuture, senderInstalled, "Failed to install InterPartitionCommandSender");
    }

    private ActorFuture<Void> installReceiver(PartitionTransitionContext context) {
        ActorFuture future = context.getConcurrencyControl().createFuture();
        context.getLogStream().newLogStreamRecordWriter().onComplete((writer, error) -> {
            if (error != null) {
                future.completeExceptionally(error);
                return;
            }
            InterPartitionCommandReceiverActor receiver = new InterPartitionCommandReceiverActor(context.getPartitionId(), context.getClusterCommunicationService(), (LogStreamRecordWriter)writer);
            context.getActorSchedulingService().submitActor((Actor)receiver);
            context.setPartitionCommandReceiver(receiver);
            context.getCheckpointProcessor().addCheckpointListener((CheckpointListener)receiver);
            future.complete(null);
        });
        return future;
    }

    private ActorFuture<Void> installSender(PartitionTransitionContext context) {
        ActorFuture future = context.getConcurrencyControl().createFuture();
        InterPartitionCommandSenderService sender = new InterPartitionCommandSenderService(context.getClusterCommunicationService(), context.getPartitionId());
        ActorFuture actorStarted = context.getActorSchedulingService().submitActor((Actor)sender);
        actorStarted.onComplete((ignore, error) -> {
            if (error == null) {
                context.setPartitionCommandSender(sender);
                context.getTopologyManager().addTopologyPartitionListener(sender);
                context.getCheckpointProcessor().addCheckpointListener((CheckpointListener)sender);
                future.complete(null);
            } else {
                future.completeExceptionally(error);
            }
        });
        return future;
    }

    private ActorFuture<Void> closeReceiver(PartitionTransitionContext context) {
        InterPartitionCommandReceiverActor receiver = context.getPartitionCommandReceiver();
        if (receiver != null) {
            ActorFuture receiverCloseFuture = receiver.closeAsync();
            receiverCloseFuture.onComplete((res, error) -> context.setPartitionCommandReceiver(null));
            return receiverCloseFuture;
        }
        return context.getConcurrencyControl().createCompletedFuture();
    }

    private ActorFuture<Void> closeSender(PartitionTransitionContext context) {
        InterPartitionCommandSenderService sender = context.getPartitionCommandSender();
        if (sender != null) {
            context.getTopologyManager().removeTopologyPartitionListener(sender);
            ActorFuture receiverCloseFuture = sender.closeAsync();
            receiverCloseFuture.onComplete((res, error) -> context.setPartitionCommandReceiver(null));
            return receiverCloseFuture;
        }
        return context.getConcurrencyControl().createCompletedFuture();
    }
}

