/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backupapi;

import io.camunda.zeebe.backup.api.BackupManager;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.broker.transport.ErrorResponseWriter;
import io.camunda.zeebe.broker.transport.backupapi.BackupApiRequestReader;
import io.camunda.zeebe.broker.transport.backupapi.BackupApiResponseWriter;
import io.camunda.zeebe.broker.transport.backupapi.NotPartitionLeaderHandler;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.protocol.impl.encoding.BackupStatusResponse;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.management.CheckpointRecord;
import io.camunda.zeebe.protocol.management.AdminRequestType;
import io.camunda.zeebe.protocol.management.BackupRequestType;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.management.CheckpointIntent;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferWriter;

public final class BackupApiRequestHandler
extends AsyncApiRequestHandler<BackupApiRequestReader, BackupApiResponseWriter>
implements DiskSpaceUsageListener {
    private boolean isDiskSpaceAvailable = true;
    private final LogStreamRecordWriter logStreamRecordWriter;
    private final BackupManager backupManager;
    private final AtomixServerTransport transport;
    private final int partitionId;
    private final boolean backupFeatureEnabled;

    public BackupApiRequestHandler(AtomixServerTransport transport, LogStreamRecordWriter logStreamRecordWriter, BackupManager backupManager, int partitionId, boolean backupFeatureEnabled) {
        super(BackupApiRequestReader::new, BackupApiResponseWriter::new);
        this.logStreamRecordWriter = logStreamRecordWriter;
        this.transport = transport;
        this.backupManager = backupManager;
        this.partitionId = partitionId;
        this.backupFeatureEnabled = backupFeatureEnabled;
        transport.unsubscribe(partitionId, RequestType.BACKUP);
        transport.subscribe(partitionId, RequestType.BACKUP, (RequestHandler)this);
    }

    public void close() {
        this.transport.unsubscribe(this.partitionId, RequestType.BACKUP);
        this.transport.subscribe(this.partitionId, RequestType.BACKUP, (RequestHandler)new NotPartitionLeaderHandler());
        super.close();
    }

    @Override
    protected ActorFuture<Either<ErrorResponseWriter, BackupApiResponseWriter>> handleAsync(int requestStreamId, long requestId, BackupApiRequestReader requestReader, BackupApiResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        if (!this.backupFeatureEnabled) {
            return CompletableActorFuture.completed(this.backupFeatureDisabledError(errorWriter));
        }
        return switch (requestReader.type()) {
            case BackupRequestType.TAKE_BACKUP -> CompletableActorFuture.completed(this.handleTakeBackupRequest(requestStreamId, requestId, requestReader, responseWriter, errorWriter));
            case BackupRequestType.QUERY_STATUS -> this.handleQueryStatusHandler(requestReader, responseWriter, errorWriter);
            default -> CompletableActorFuture.completed(this.unknownRequest(errorWriter, requestReader.getMessageDecoder().type()));
        };
    }

    private Either<ErrorResponseWriter, BackupApiResponseWriter> handleTakeBackupRequest(int requestStreamId, long requestId, BackupApiRequestReader requestReader, BackupApiResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        if (!this.isDiskSpaceAvailable) {
            return Either.left((Object)errorWriter.outOfDiskSpace(this.partitionId));
        }
        RecordMetadata metadata = new RecordMetadata().recordType(RecordType.COMMAND).valueType(ValueType.CHECKPOINT).intent((Intent)CheckpointIntent.CREATE).requestId(requestId).requestStreamId(requestStreamId);
        CheckpointRecord checkpointRecord = new CheckpointRecord().setCheckpointId(requestReader.backupId());
        long written = this.logStreamRecordWriter.metadataWriter((BufferWriter)metadata).valueWriter((BufferWriter)checkpointRecord).tryWrite();
        if (written > 0L) {
            return Either.right((Object)responseWriter.noResponse());
        }
        return Either.left((Object)errorWriter.internalError("Failed to write command to logstream.", new Object[0]));
    }

    private ActorFuture<Either<ErrorResponseWriter, BackupApiResponseWriter>> handleQueryStatusHandler(BackupApiRequestReader requestReader, BackupApiResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        CompletableActorFuture result = new CompletableActorFuture();
        long backupId = requestReader.backupId();
        this.backupManager.getBackupStatus(backupId).onComplete((arg_0, arg_1) -> this.lambda$handleQueryStatusHandler$0((ActorFuture)result, responseWriter, errorWriter, arg_0, arg_1));
        return result;
    }

    private BackupStatusResponse buildResponse(BackupStatus status) {
        BackupStatusResponse response = new BackupStatusResponse().setBackupId(status.id().checkpointId()).setBrokerId(status.id().nodeId()).setPartitionId(status.id().partitionId()).setStatus(this.encodeStatusCode(status.statusCode()));
        status.descriptor().ifPresent(backupDescriptor -> response.setCheckpointPosition(backupDescriptor.checkpointPosition()).setSnapshotId(backupDescriptor.snapshotId().orElse("")).setNumberOfPartitions(backupDescriptor.numberOfPartitions()).setBrokerVersion(backupDescriptor.brokerVersion()));
        status.failureReason().ifPresent(arg_0 -> ((BackupStatusResponse)response).setFailureReason(arg_0));
        status.created().ifPresent(instant -> response.setCreatedAt(instant.toString()));
        status.lastModified().ifPresent(instant -> response.setLastUpdated(instant.toString()));
        return response;
    }

    private Either<ErrorResponseWriter, BackupApiResponseWriter> unknownRequest(ErrorResponseWriter errorWriter, BackupRequestType type) {
        errorWriter.unsupportedMessage(type, AdminRequestType.values());
        return Either.left((Object)errorWriter);
    }

    private Either<ErrorResponseWriter, BackupApiResponseWriter> backupFeatureDisabledError(ErrorResponseWriter errorWriter) {
        errorWriter.errorCode(ErrorCode.UNSUPPORTED_MESSAGE).errorMessage("Backup feature is disabled for this cluster. To use this feature, enable it in the broker configuration and restart the cluster.");
        return Either.left((Object)errorWriter);
    }

    @Override
    public void onDiskSpaceNotAvailable() {
        this.actor.submit(() -> {
            this.isDiskSpaceAvailable = false;
        });
    }

    @Override
    public void onDiskSpaceAvailable() {
        this.actor.submit(() -> {
            this.isDiskSpaceAvailable = true;
        });
    }

    private io.camunda.zeebe.protocol.management.BackupStatusCode encodeStatusCode(BackupStatusCode statusCode) {
        return switch (statusCode) {
            default -> throw new IncompatibleClassChangeError();
            case BackupStatusCode.DOES_NOT_EXIST -> io.camunda.zeebe.protocol.management.BackupStatusCode.DOES_NOT_EXIST;
            case BackupStatusCode.IN_PROGRESS -> io.camunda.zeebe.protocol.management.BackupStatusCode.IN_PROGRESS;
            case BackupStatusCode.COMPLETED -> io.camunda.zeebe.protocol.management.BackupStatusCode.COMPLETED;
            case BackupStatusCode.FAILED -> io.camunda.zeebe.protocol.management.BackupStatusCode.FAILED;
        };
    }

    private /* synthetic */ void lambda$handleQueryStatusHandler$0(ActorFuture result, BackupApiResponseWriter responseWriter, ErrorResponseWriter errorWriter, BackupStatus status, Throwable error) {
        if (error == null) {
            BackupStatusResponse response = this.buildResponse(status);
            result.complete((Object)Either.right((Object)responseWriter.withStatus(response)));
        } else {
            errorWriter.errorCode(ErrorCode.INTERNAL_ERROR).errorMessage(error.getMessage());
            result.complete((Object)Either.left((Object)errorWriter));
        }
    }
}

