/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backupapi;

import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.protocol.impl.encoding.BackupStatusResponse;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.transport.impl.ServerResponseImpl;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.MutableDirectBuffer;

public final class BackupApiResponseWriter
implements AsyncApiRequestHandler.ResponseWriter {
    private final ServerResponseImpl response = new ServerResponseImpl();
    private boolean hasResponse = true;
    private BackupStatusResponse status;

    public BackupApiResponseWriter withStatus(BackupStatusResponse response) {
        this.status = response;
        this.hasResponse = true;
        return this;
    }

    public BackupApiResponseWriter noResponse() {
        this.hasResponse = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryWriteResponse(ServerOutput output, int partitionId, long requestId) {
        if (this.hasResponse) {
            try {
                this.response.reset().writer((BufferWriter)this).setPartitionId(partitionId).setRequestId(requestId);
                output.sendResponse((ServerResponse)this.response);
            }
            finally {
                this.reset();
            }
        }
    }

    @Override
    public void reset() {
        this.response.reset();
        this.hasResponse = true;
    }

    public int getLength() {
        if (this.hasResponse) {
            return 8 + this.status.getLength();
        }
        return 0;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.status.write(buffer, offset);
    }
}

