/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.broker.transport.ErrorResponseWriter;
import io.camunda.zeebe.broker.transport.backpressure.BackpressureMetrics;
import io.camunda.zeebe.broker.transport.backpressure.RequestLimiter;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiRequestReader;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiResponseWriter;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.collections.Int2ObjectHashMap;
import org.slf4j.Logger;

final class CommandApiRequestHandler
extends AsyncApiRequestHandler<CommandApiRequestReader, CommandApiResponseWriter> {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private final Int2ObjectHashMap<LogStreamRecordWriter> leadingStreams = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<RequestLimiter<Intent>> partitionLimiters = new Int2ObjectHashMap();
    private final BackpressureMetrics metrics = new BackpressureMetrics();
    private boolean isDiskSpaceAvailable = true;

    CommandApiRequestHandler() {
        super(CommandApiRequestReader::new, CommandApiResponseWriter::new);
    }

    @Override
    protected ActorFuture<Either<ErrorResponseWriter, CommandApiResponseWriter>> handleAsync(int partitionId, long requestId, CommandApiRequestReader requestReader, CommandApiResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        return CompletableActorFuture.completed(this.handle(partitionId, requestId, requestReader, responseWriter, errorWriter));
    }

    private Either<ErrorResponseWriter, CommandApiResponseWriter> handle(int partitionId, long requestId, CommandApiRequestReader requestReader, CommandApiResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        return this.handleExecuteCommandRequest(partitionId, requestId, requestReader, responseWriter, errorWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Either<ErrorResponseWriter, CommandApiResponseWriter> handleExecuteCommandRequest(int partitionId, long requestId, CommandApiRequestReader reader, CommandApiResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        if (!this.isDiskSpaceAvailable) {
            return Either.left((Object)errorWriter.outOfDiskSpace(partitionId));
        }
        ExecuteCommandRequestDecoder command = reader.getMessageDecoder();
        LogStreamRecordWriter logStreamWriter = (LogStreamRecordWriter)this.leadingStreams.get(partitionId);
        RequestLimiter limiter = (RequestLimiter)this.partitionLimiters.get(partitionId);
        ValueType eventType = command.valueType();
        Intent intent = Intent.fromProtocolValue((ValueType)eventType, (short)command.intent());
        UnpackedObject event = reader.event();
        RecordMetadata metadata = reader.metadata();
        metadata.requestId(requestId);
        metadata.requestStreamId(partitionId);
        metadata.recordType(RecordType.COMMAND);
        metadata.intent(intent);
        metadata.valueType(eventType);
        if (logStreamWriter == null) {
            errorWriter.partitionLeaderMismatch(partitionId);
            return Either.left((Object)errorWriter);
        }
        if (event == null) {
            errorWriter.unsupportedMessage(eventType.name(), CommandApiRequestReader.RECORDS_BY_TYPE.keySet().toArray());
            return Either.left((Object)errorWriter);
        }
        this.metrics.receivedRequest(partitionId);
        if (!limiter.tryAcquire(partitionId, requestId, intent)) {
            this.metrics.dropped(partitionId);
            LOG.trace("Partition-{} receiving too many requests. Current limit {} inflight {}, dropping request {} from gateway", new Object[]{partitionId, limiter.getLimit(), limiter.getInflightCount(), requestId});
            errorWriter.resourceExhausted();
            return Either.left((Object)errorWriter);
        }
        boolean written = false;
        try {
            written = this.writeCommand(command.key(), metadata, event, logStreamWriter);
            Either either = Either.right((Object)responseWriter);
            return either;
        }
        catch (Exception ex) {
            LOG.error("Unexpected error on writing {} command", (Object)intent, (Object)ex);
            errorWriter.internalError("Failed writing response: %s", ex);
            Either either = Either.left((Object)errorWriter);
            return either;
        }
        finally {
            if (!written) {
                limiter.onIgnore(partitionId, requestId);
            }
        }
    }

    private boolean writeCommand(long key, RecordMetadata eventMetadata, UnpackedObject event, LogStreamRecordWriter logStreamWriter) {
        logStreamWriter.reset();
        if (key != ExecuteCommandRequestDecoder.keyNullValue()) {
            logStreamWriter.key(key);
        } else {
            logStreamWriter.keyNull();
        }
        long eventPosition = logStreamWriter.metadataWriter((BufferWriter)eventMetadata).valueWriter((BufferWriter)event).tryWrite();
        return eventPosition >= 0L;
    }

    void addPartition(int partitionId, LogStreamRecordWriter logStreamWriter, RequestLimiter<Intent> limiter) {
        this.actor.submit(() -> {
            this.leadingStreams.put(partitionId, (Object)logStreamWriter);
            this.partitionLimiters.put(partitionId, (Object)limiter);
        });
    }

    void removePartition(int partitionId) {
        this.actor.submit(() -> {
            this.leadingStreams.remove(partitionId);
            this.partitionLimiters.remove(partitionId);
        });
    }

    void onDiskSpaceNotAvailable() {
        this.actor.submit(() -> {
            this.isDiskSpaceAvailable = false;
            LOG.debug("Broker is out of disk space. All client requests will be rejected");
        });
    }

    void onDiskSpaceAvailable() {
        this.actor.submit(() -> {
            this.isDiskSpaceAvailable = true;
        });
    }
}

