/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.utils.Builder;
import io.atomix.utils.Version;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.util.VersionUtil;
import java.io.File;
import java.util.Collection;
import java.util.Properties;

public class AtomixClusterBuilder
implements Builder<AtomixCluster> {
    protected final ClusterConfig config;

    public AtomixClusterBuilder(ClusterConfig config) {
        this.config = (ClusterConfig)Preconditions.checkNotNull((Object)config);
    }

    public AtomixClusterBuilder withClusterId(String clusterId) {
        this.config.setClusterId(clusterId);
        return this;
    }

    public AtomixClusterBuilder withMemberId(String localMemberId) {
        this.config.getNodeConfig().setId(localMemberId);
        return this;
    }

    public AtomixClusterBuilder withMemberId(MemberId localMemberId) {
        this.config.getNodeConfig().setId(localMemberId);
        return this;
    }

    public AtomixClusterBuilder withHost(String host) {
        this.config.getNodeConfig().setHost(host);
        return this;
    }

    public AtomixClusterBuilder withPort(int port) {
        this.config.getNodeConfig().setPort(port);
        return this;
    }

    public AtomixClusterBuilder withAddress(Address address) {
        this.config.getNodeConfig().setAddress(address);
        return this;
    }

    public AtomixClusterBuilder withProperties(Properties properties) {
        this.config.getNodeConfig().setProperties(properties);
        return this;
    }

    public AtomixClusterBuilder withMessagingInterface(String iface) {
        return this.withMessagingInterfaces(Lists.newArrayList((Object[])new String[]{iface}));
    }

    public AtomixClusterBuilder withMessagingInterfaces(Collection<String> ifaces) {
        this.config.getMessagingConfig().setInterfaces(Lists.newArrayList(ifaces));
        return this;
    }

    public AtomixClusterBuilder withMessagingPort(int bindPort) {
        this.config.getMessagingConfig().setPort(bindPort);
        return this;
    }

    public AtomixClusterBuilder withMembershipProtocol(GroupMembershipProtocol protocol) {
        this.config.setProtocolConfig((GroupMembershipProtocolConfig)protocol.config());
        return this;
    }

    public AtomixClusterBuilder withMembershipProvider(NodeDiscoveryProvider locationProvider) {
        this.config.setDiscoveryConfig((NodeDiscoveryConfig)locationProvider.config());
        return this;
    }

    public AtomixClusterBuilder withSecurity(File certificateChain, File privateKey) {
        this.config.getMessagingConfig().setTlsEnabled(true).setCertificateChain(certificateChain).setPrivateKey(privateKey);
        return this;
    }

    public AtomixClusterBuilder withMessageCompression(MessagingConfig.CompressionAlgorithm messageCompression) {
        this.config.getMessagingConfig().setCompressionAlgorithm(messageCompression);
        return this;
    }

    public AtomixCluster build() {
        return new AtomixCluster(this.config, Version.from((String)VersionUtil.getVersion()));
    }
}

