/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl.zeebe;

import io.atomix.raft.metrics.RaftServiceMetrics;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.utils.concurrent.ThreadContext;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public final class LogCompactor {
    private final ThreadContext threadContext;
    private final RaftLog log;
    private final int replicationThreshold;
    private final Logger logger;
    private final RaftServiceMetrics metrics;
    private volatile long compactableIndex;

    public LogCompactor(ThreadContext threadContext, RaftLog log, int replicationThreshold, RaftServiceMetrics metrics, Logger logger) {
        this.threadContext = threadContext;
        this.log = log;
        this.replicationThreshold = replicationThreshold;
        this.logger = logger;
        this.metrics = metrics;
    }

    public ThreadContext executor() {
        return this.threadContext;
    }

    public CompletableFuture<Void> compact() {
        this.threadContext.checkThread();
        long index = this.compactableIndex - (long)this.replicationThreshold;
        this.logger.debug("Compacting up to {} ({} - {})", new Object[]{index, this.compactableIndex, this.replicationThreshold});
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            long startTime = System.currentTimeMillis();
            this.log.deleteUntil(index);
            this.metrics.compactionTime(System.currentTimeMillis() - startTime);
            result.complete(null);
        }
        catch (Exception e) {
            this.logger.error("Failed to compact up to index {}", (Object)index, (Object)e);
            result.completeExceptionally(e);
        }
        return result;
    }

    public void setCompactableIndex(long index) {
        this.compactableIndex = index;
    }

    public void compactFromSnapshots(PersistedSnapshotStore snapshotStore) {
        snapshotStore.getCompactionBound().onComplete(this::onSnapshotCompactionBound, (Executor)this.threadContext);
    }

    private void onSnapshotCompactionBound(Long index, Throwable error) {
        if (error != null) {
            this.logger.error("Expected to compact logs, but could not the compaction bound from the snapshot store", error);
            return;
        }
        this.setCompactableIndex(index);
        this.compact();
    }
}

