/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.raft.storage.StorageException;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.system.MetaStore;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;

public final class RaftStorage {
    private final String prefix;
    private final File directory;
    private final int maxSegmentSize;
    private final long freeDiskSpace;
    private final boolean flushExplicitly;
    private final ReceivableSnapshotStore persistedSnapshotStore;
    private final int journalIndexDensity;
    private final boolean preallocateSegmentFiles;

    private RaftStorage(String prefix, File directory, int maxSegmentSize, long freeDiskSpace, boolean flushExplicitly, ReceivableSnapshotStore persistedSnapshotStore, int journalIndexDensity, boolean preallocateSegmentFiles) {
        this.prefix = prefix;
        this.directory = directory;
        this.maxSegmentSize = maxSegmentSize;
        this.freeDiskSpace = freeDiskSpace;
        this.flushExplicitly = flushExplicitly;
        this.persistedSnapshotStore = persistedSnapshotStore;
        this.journalIndexDensity = journalIndexDensity;
        this.preallocateSegmentFiles = preallocateSegmentFiles;
        try {
            FileUtil.ensureDirectoryExists((Path)directory.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create partition's directory %s", directory.toPath()), e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String prefix() {
        return this.prefix;
    }

    public boolean lock(String id) {
        File lockFile = new File(this.directory, String.format(".%s.lock", this.prefix));
        File tempLockFile = new File(this.directory, String.format(".%s.lock.tmp", id));
        try {
            String lock;
            if (!lockFile.exists()) {
                Files.writeString(tempLockFile.toPath(), (CharSequence)id, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
                FileUtil.moveDurably((Path)tempLockFile.toPath(), (Path)lockFile.toPath(), (CopyOption[])new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
            }
            return (lock = Files.readString(lockFile.toPath())) != null && lock.equals(id);
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
        catch (IOException e) {
            throw new StorageException("Failed to acquire storage lock", e);
        }
    }

    public MetaStore openMetaStore() {
        try {
            return new MetaStore(this);
        }
        catch (IOException e) {
            throw new StorageException("Failed to open metastore", e);
        }
    }

    public ReceivableSnapshotStore getPersistedSnapshotStore() {
        return this.persistedSnapshotStore;
    }

    public RaftLog openLog(MetaStore metaStore) {
        return RaftLog.builder().withName(this.prefix).withDirectory(this.directory).withMaxSegmentSize(this.maxSegmentSize).withFreeDiskSpace(this.freeDiskSpace).withFlushExplicitly(this.flushExplicitly).withJournalIndexDensity(this.journalIndexDensity).withMetaStore(metaStore).withPreallocateSegmentFiles(this.preallocateSegmentFiles).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("directory", (Object)this.directory()).toString();
    }

    public File directory() {
        return this.directory;
    }

    public static final class Builder
    implements io.atomix.utils.Builder<RaftStorage> {
        private static final String DEFAULT_PREFIX = "atomix";
        private static final String DEFAULT_DIRECTORY = System.getProperty("atomix.data", System.getProperty("user.dir"));
        private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
        private static final long DEFAULT_FREE_DISK_SPACE = 0x40000000L;
        private static final boolean DEFAULT_FLUSH_EXPLICITLY = true;
        private static final int DEFAULT_JOURNAL_INDEX_DENSITY = 100;
        private static final boolean DEFAULT_PREALLOCATE_SEGMENT_FILES = true;
        private String prefix = "atomix";
        private File directory = new File(DEFAULT_DIRECTORY);
        private int maxSegmentSize = 0x2000000;
        private long freeDiskSpace = 0x40000000L;
        private boolean flushExplicitly = true;
        private ReceivableSnapshotStore persistedSnapshotStore;
        private int journalIndexDensity = 100;
        private boolean preallocateSegmentFiles = true;

        private Builder() {
        }

        public Builder withPrefix(String prefix) {
            this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix cannot be null");
            return this;
        }

        public Builder withDirectory(File directory) {
            this.directory = (File)Preconditions.checkNotNull((Object)directory, (Object)"directory");
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        public Builder withFreeDiskSpace(long freeDiskSpace) {
            Preconditions.checkArgument((freeDiskSpace >= 0L ? 1 : 0) != 0, (Object)"freeDiskSpace must be positive");
            this.freeDiskSpace = freeDiskSpace;
            return this;
        }

        public Builder withFlushExplicitly(boolean flushExplicitly) {
            this.flushExplicitly = flushExplicitly;
            return this;
        }

        public Builder withSnapshotStore(ReceivableSnapshotStore persistedSnapshotStore) {
            this.persistedSnapshotStore = persistedSnapshotStore;
            return this;
        }

        public Builder withJournalIndexDensity(int journalIndexDensity) {
            this.journalIndexDensity = journalIndexDensity;
            return this;
        }

        public Builder withPreallocateSegmentFiles(boolean preallocateSegmentFiles) {
            this.preallocateSegmentFiles = preallocateSegmentFiles;
            return this;
        }

        public RaftStorage build() {
            return new RaftStorage(this.prefix, this.directory, this.maxSegmentSize, this.freeDiskSpace, this.flushExplicitly, this.persistedSnapshotStore, this.journalIndexDensity, this.preallocateSegmentFiles);
        }
    }
}

