/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.protocol.PersistedRaftRecord;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.IndexedRaftLogEntryImpl;
import io.atomix.raft.storage.log.RaftLogBuilder;
import io.atomix.raft.storage.log.RaftLogCommittedReader;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.RaftLogUncommittedReader;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.serializer.RaftEntrySBESerializer;
import io.atomix.raft.storage.serializer.RaftEntrySerializer;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.journal.JournalRecord;
import java.io.Closeable;
import org.agrona.CloseHelper;

public final class RaftLog
implements Closeable {
    private final Journal journal;
    private final RaftEntrySerializer serializer = new RaftEntrySBESerializer();
    private final boolean flushExplicitly;
    private IndexedRaftLogEntry lastAppendedEntry;
    private volatile long commitIndex;

    RaftLog(Journal journal, boolean flushExplicitly) {
        this.journal = journal;
        this.flushExplicitly = flushExplicitly;
    }

    public static RaftLogBuilder builder() {
        return new RaftLogBuilder();
    }

    public RaftLogReader openUncommittedReader() {
        return new RaftLogUncommittedReader(this.journal.openReader());
    }

    public RaftLogReader openCommittedReader() {
        return new RaftLogCommittedReader(this, new RaftLogUncommittedReader(this.journal.openReader()));
    }

    public boolean isOpen() {
        return this.journal.isOpen();
    }

    public void deleteUntil(long index) {
        this.journal.deleteUntil(index);
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public void setCommitIndex(long index) {
        this.commitIndex = index;
    }

    public boolean shouldFlushExplicitly() {
        return this.flushExplicitly;
    }

    public long getFirstIndex() {
        return this.journal.getFirstIndex();
    }

    public long getLastIndex() {
        return this.journal.getLastIndex();
    }

    public IndexedRaftLogEntry getLastEntry() {
        if (this.lastAppendedEntry == null) {
            this.readLastEntry();
        }
        return this.lastAppendedEntry;
    }

    private void readLastEntry() {
        try (RaftLogReader reader = this.openUncommittedReader();){
            reader.seekToLast();
            if (reader.hasNext()) {
                this.lastAppendedEntry = (IndexedRaftLogEntry)reader.next();
            }
        }
    }

    public boolean isEmpty() {
        return this.journal.isEmpty();
    }

    public IndexedRaftLogEntry append(RaftLogEntry entry) {
        JournalRecord journalRecord = this.journal.append(entry.getLowestAsqn().orElse(-1L).longValue(), entry.entry().toSerializable(entry.term(), this.serializer));
        this.lastAppendedEntry = new IndexedRaftLogEntryImpl(entry.term(), entry.entry(), journalRecord);
        return this.lastAppendedEntry;
    }

    public IndexedRaftLogEntry append(PersistedRaftRecord entry) {
        this.journal.append((JournalRecord)entry);
        RaftLogEntry raftEntry = this.serializer.readRaftLogEntry(entry.data());
        this.lastAppendedEntry = new IndexedRaftLogEntryImpl(entry.term(), raftEntry.entry(), entry);
        return this.lastAppendedEntry;
    }

    public void reset(long index) {
        this.journal.reset(index);
        this.lastAppendedEntry = null;
    }

    public void deleteAfter(long index) {
        if (index < this.commitIndex) {
            throw new IllegalStateException(String.format("Expected to delete index after %d, but it is lower than the commit index %d. Deleting committed entries can lead to inconsistencies and is prohibited.", index, this.commitIndex));
        }
        this.journal.deleteAfter(index);
        this.lastAppendedEntry = null;
    }

    public void flush() {
        this.journal.flush();
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.journal);
    }

    public String toString() {
        return "RaftLog{journal=" + this.journal + ", serializer=" + this.serializer + ", flushExplicitly=" + this.flushExplicitly + ", lastAppendedEntry=" + this.lastAppendedEntry + ", commitIndex=" + this.commitIndex + "}";
    }
}

