/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.system;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.MemberId;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.StorageException;
import io.atomix.raft.storage.serializer.MetaEncoder;
import io.atomix.raft.storage.serializer.MetaStoreSerializer;
import io.atomix.raft.storage.system.Configuration;
import io.camunda.zeebe.journal.JournalMetaStore;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStore
implements JournalMetaStore,
AutoCloseable {
    private static final byte VERSION = 1;
    private static final int VERSION_LENGTH = 1;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ByteBuffer metaBuffer = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
    private final FileChannel configurationChannel;
    private final File confFile;
    private final MetaStoreSerializer serializer = new MetaStoreSerializer();
    private final FileChannel metaFileChannel;
    private volatile long lastFlushedIndex;

    public MetaStore(RaftStorage storage) throws IOException {
        if (!storage.directory().isDirectory() && !storage.directory().mkdirs()) {
            throw new IllegalArgumentException(String.format("Can't create storage directory [%s].", storage.directory()));
        }
        File metaFile = new File(storage.directory(), String.format("%s.meta", storage.prefix()));
        if (!metaFile.exists()) {
            Files.write(metaFile.toPath(), new byte[32], StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            this.lastFlushedIndex = MetaEncoder.lastFlushedIndexNullValue();
        }
        this.metaFileChannel = FileChannel.open(metaFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
        this.confFile = new File(storage.directory(), String.format("%s.conf", storage.prefix()));
        if (!this.confFile.exists()) {
            Files.write(this.confFile.toPath(), new byte[32], StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
        }
        this.configurationChannel = FileChannel.open(this.confFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.lastFlushedIndex = this.readLastFlushedIndex();
        this.initializeMetaBuffer();
    }

    private void initializeMetaBuffer() {
        long term = this.loadTerm();
        long index = this.loadLastFlushedIndex();
        MemberId voted = this.loadVote();
        this.metaBuffer.put(0, (byte)1);
        this.storeTerm(term);
        this.storeLastFlushedIndex(index);
        this.storeVote(voted);
    }

    public synchronized void storeTerm(long term) {
        this.log.trace("Store term {}", (Object)term);
        UnsafeBuffer directBuffer = new UnsafeBuffer(this.metaBuffer);
        this.serializer.writeTerm(term, (MutableDirectBuffer)directBuffer, 1);
        try {
            this.metaFileChannel.write(this.metaBuffer, 0L);
            this.metaBuffer.position(0);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public synchronized long loadTerm() {
        try {
            this.metaFileChannel.read(this.metaBuffer, 0L);
            this.metaBuffer.position(0);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        return this.serializer.readTerm((MutableDirectBuffer)new UnsafeBuffer(this.metaBuffer), 1);
    }

    public synchronized void storeVote(MemberId vote) {
        this.log.trace("Store vote {}", (Object)vote);
        try {
            String id = vote == null ? null : (String)((Object)vote.id());
            this.serializer.writeVotedFor(id, (MutableDirectBuffer)new UnsafeBuffer(this.metaBuffer), 1);
            this.metaFileChannel.write(this.metaBuffer, 0L);
            this.metaBuffer.position(0);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public synchronized MemberId loadVote() {
        try {
            this.metaFileChannel.read(this.metaBuffer, 0L);
            this.metaBuffer.position(0);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        String id = this.serializer.readVotedFor((MutableDirectBuffer)new UnsafeBuffer(this.metaBuffer), 1);
        return id.isEmpty() ? null : MemberId.from(id);
    }

    public synchronized void storeLastFlushedIndex(long index) {
        if (index == this.lastFlushedIndex) {
            this.log.trace("Skip storing same last flushed index {}", (Object)index);
            return;
        }
        this.log.trace("Store last flushed index {}", (Object)index);
        try {
            this.serializer.writeLastFlushedIndex(index, (MutableDirectBuffer)new UnsafeBuffer(this.metaBuffer), 1);
            this.metaFileChannel.write(this.metaBuffer, 0L);
            this.lastFlushedIndex = index;
            this.metaBuffer.position(0);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public synchronized long loadLastFlushedIndex() {
        return this.lastFlushedIndex;
    }

    public void resetLastFlushedIndex() {
        this.storeLastFlushedIndex(MetaEncoder.lastFlushedIndexNullValue());
    }

    public boolean hasLastFlushedIndex() {
        return this.lastFlushedIndex != MetaEncoder.lastFlushedIndexNullValue();
    }

    public synchronized void storeConfiguration(Configuration configuration) {
        this.log.trace("Store configuration {}", (Object)configuration);
        ExpandableArrayBuffer serializedBuffer = new ExpandableArrayBuffer();
        serializedBuffer.putByte(0, (byte)1);
        int serializedLength = this.serializer.writeConfiguration(configuration, (MutableDirectBuffer)serializedBuffer, 1);
        ByteBuffer buffer = ByteBuffer.allocate(1 + serializedLength);
        serializedBuffer.getBytes(0, buffer, 0, 1 + serializedLength);
        try {
            this.configurationChannel.write(buffer, 0L);
            this.configurationChannel.force(true);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public synchronized Configuration loadConfiguration() {
        try {
            this.configurationChannel.position(0L);
            ByteBuffer buffer = ByteBuffer.allocate((int)this.confFile.length());
            this.configurationChannel.read(buffer);
            buffer.position(0);
            return this.serializer.readConfiguration((DirectBuffer)new UnsafeBuffer(buffer), 1);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.metaFileChannel.close();
            this.configurationChannel.close();
        }
        catch (IOException e) {
            this.log.warn("Failed to close metastore", (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    private long readLastFlushedIndex() {
        try {
            this.metaFileChannel.read(this.metaBuffer, 0L);
            this.metaBuffer.position(0);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        return this.serializer.readLastFlushedIndex((MutableDirectBuffer)new UnsafeBuffer(this.metaBuffer), 1);
    }
}

