/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.utils;

import java.util.function.LongConsumer;
import org.slf4j.Logger;

public class StateUtil {
    public static void verifySnapshotLogConsistent(long partitionId, long snapshotIndex, long firstIndex, boolean isLogEmpty, LongConsumer logResetter, Logger log) {
        boolean noGapExists;
        boolean bl = noGapExists = firstIndex == 1L || snapshotIndex > 0L && snapshotIndex + 1L >= firstIndex;
        if (noGapExists) {
            return;
        }
        if (!isLogEmpty) {
            throw new IllegalStateException(String.format("In partition %d expected to find a snapshot at index >= log's first index %d, but found snapshot %d. A previous snapshot is most likely corrupted.", partitionId, firstIndex, snapshotIndex));
        }
        log.info("In partition {} current snapshot index ({}) is lower than log's first index {}. But the log is empty. Most likely the node crashed while committing a snapshot at index {}. Resetting log to {}", new Object[]{partitionId, snapshotIndex, firstIndex, firstIndex - 1L, snapshotIndex + 1L});
        logResetter.accept(snapshotIndex + 1L);
    }
}

