/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

final class JournalMetrics {
    private static final String NAMESPACE = "atomix";
    private static final String PARTITION_LABEL = "partition";
    private static final Histogram SEGMENT_CREATION_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_creation_time")).help("Time spend to create a new segment")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_TRUNCATE_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_truncate_time")).help("Time spend to truncate a segment")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_FLUSH_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_flush_time")).help("Time spend to flush segment to disk")).labelNames(new String[]{"partition"})).register();
    private static final Gauge SEGMENT_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("segment_count")).help("Number of segments")).labelNames(new String[]{"partition"})).register();
    private static final Gauge JOURNAL_OPEN_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("journal_open_time")).help("Time taken to open the journal")).labelNames(new String[]{"partition"})).register();
    private final String logName;

    JournalMetrics(String logName) {
        this.logName = logName;
    }

    void observeSegmentCreation(Runnable segmentCreation) {
        ((Histogram.Child)SEGMENT_CREATION_TIME.labels(new String[]{this.logName})).time(segmentCreation);
    }

    void observeSegmentFlush(Runnable segmentFlush) {
        ((Histogram.Child)SEGMENT_FLUSH_TIME.labels(new String[]{this.logName})).time(segmentFlush);
    }

    void observeSegmentTruncation(Runnable segmentTruncation) {
        ((Histogram.Child)SEGMENT_TRUNCATE_TIME.labels(new String[]{this.logName})).time(segmentTruncation);
    }

    Gauge.Timer startJournalOpenDurationTimer() {
        return ((Gauge.Child)JOURNAL_OPEN_DURATION.labels(new String[]{this.logName})).startTimer();
    }

    void incSegmentCount() {
        ((Gauge.Child)SEGMENT_COUNT.labels(new String[]{this.logName})).inc();
    }

    void decSegmentCount() {
        ((Gauge.Child)SEGMENT_COUNT.labels(new String[]{this.logName})).dec();
    }
}

