/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Iterator;
import org.agrona.DirectBuffer;

public final class ResponseMapper {
    public static GatewayOuterClass.DeployProcessResponse toDeployProcessResponse(long key, DeploymentRecord brokerResponse) {
        GatewayOuterClass.DeployProcessResponse.Builder responseBuilder = GatewayOuterClass.DeployProcessResponse.newBuilder().setKey(key);
        brokerResponse.processesMetadata().forEach(process -> responseBuilder.addProcessesBuilder().setBpmnProcessId(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessIdBuffer())).setVersion(process.getVersion()).setProcessDefinitionKey(process.getKey()).setResourceName(BufferUtil.bufferAsString((DirectBuffer)process.getResourceNameBuffer())));
        return responseBuilder.build();
    }

    public static GatewayOuterClass.DeployResourceResponse toDeployResourceResponse(long key, DeploymentRecord brokerResponse) {
        GatewayOuterClass.DeployResourceResponse.Builder responseBuilder = GatewayOuterClass.DeployResourceResponse.newBuilder().setKey(key);
        brokerResponse.processesMetadata().stream().map(process -> GatewayOuterClass.ProcessMetadata.newBuilder().setBpmnProcessId(process.getBpmnProcessId()).setVersion(process.getVersion()).setProcessDefinitionKey(process.getKey()).setResourceName(process.getResourceName()).build()).forEach(process -> responseBuilder.addDeploymentsBuilder().setProcess(process));
        brokerResponse.decisionsMetadata().stream().map(decision -> GatewayOuterClass.DecisionMetadata.newBuilder().setDmnDecisionId(decision.getDecisionId()).setDmnDecisionName(decision.getDecisionName()).setVersion(decision.getVersion()).setDecisionKey(decision.getDecisionKey()).setDmnDecisionRequirementsId(decision.getDecisionRequirementsId()).setDecisionRequirementsKey(decision.getDecisionRequirementsKey()).build()).forEach(decision -> responseBuilder.addDeploymentsBuilder().setDecision(decision));
        brokerResponse.decisionRequirementsMetadata().stream().map(drg -> GatewayOuterClass.DecisionRequirementsMetadata.newBuilder().setDmnDecisionRequirementsId(drg.getDecisionRequirementsId()).setDmnDecisionRequirementsName(drg.getDecisionRequirementsName()).setVersion(drg.getDecisionRequirementsVersion()).setDecisionRequirementsKey(drg.getDecisionRequirementsKey()).setResourceName(drg.getResourceName()).build()).forEach(drg -> responseBuilder.addDeploymentsBuilder().setDecisionRequirements(drg));
        return responseBuilder.build();
    }

    public static GatewayOuterClass.PublishMessageResponse toPublishMessageResponse(long key, Object brokerResponse) {
        return GatewayOuterClass.PublishMessageResponse.newBuilder().setKey(key).build();
    }

    public static GatewayOuterClass.UpdateJobRetriesResponse toUpdateJobRetriesResponse(long key, JobRecord brokerResponse) {
        return GatewayOuterClass.UpdateJobRetriesResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.FailJobResponse toFailJobResponse(long key, JobRecord brokerResponse) {
        return GatewayOuterClass.FailJobResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.ThrowErrorResponse toThrowErrorResponse(long key, JobRecord brokerResponse) {
        return GatewayOuterClass.ThrowErrorResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.CompleteJobResponse toCompleteJobResponse(long key, JobRecord brokerResponse) {
        return GatewayOuterClass.CompleteJobResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.CreateProcessInstanceResponse toCreateProcessInstanceResponse(long key, ProcessInstanceCreationRecord brokerResponse) {
        return GatewayOuterClass.CreateProcessInstanceResponse.newBuilder().setProcessDefinitionKey(brokerResponse.getProcessDefinitionKey()).setBpmnProcessId(BufferUtil.bufferAsString((DirectBuffer)brokerResponse.getBpmnProcessIdBuffer())).setVersion(brokerResponse.getVersion()).setProcessInstanceKey(brokerResponse.getProcessInstanceKey()).build();
    }

    public static GatewayOuterClass.CreateProcessInstanceWithResultResponse toCreateProcessInstanceWithResultResponse(long key, ProcessInstanceResultRecord brokerResponse) {
        return GatewayOuterClass.CreateProcessInstanceWithResultResponse.newBuilder().setProcessDefinitionKey(brokerResponse.getProcessDefinitionKey()).setBpmnProcessId(BufferUtil.bufferAsString((DirectBuffer)brokerResponse.getBpmnProcessIdBuffer())).setVersion(brokerResponse.getVersion()).setProcessInstanceKey(brokerResponse.getProcessInstanceKey()).setVariables(ResponseMapper.bufferAsJson(brokerResponse.getVariablesBuffer())).build();
    }

    public static GatewayOuterClass.CancelProcessInstanceResponse toCancelProcessInstanceResponse(long key, ProcessInstanceRecord brokerResponse) {
        return GatewayOuterClass.CancelProcessInstanceResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.SetVariablesResponse toSetVariablesResponse(long key, VariableDocumentRecord brokerResponse) {
        return GatewayOuterClass.SetVariablesResponse.newBuilder().setKey(key).build();
    }

    public static GatewayOuterClass.ActivateJobsResponse toActivateJobsResponse(long key, JobBatchRecord brokerResponse) {
        GatewayOuterClass.ActivateJobsResponse.Builder responseBuilder = GatewayOuterClass.ActivateJobsResponse.newBuilder();
        Iterator jobKeys = brokerResponse.jobKeys().iterator();
        Iterator jobs = brokerResponse.jobs().iterator();
        while (jobKeys.hasNext() && jobs.hasNext()) {
            LongValue jobKey = (LongValue)jobKeys.next();
            JobRecord job = (JobRecord)jobs.next();
            GatewayOuterClass.ActivatedJob activatedJob = GatewayOuterClass.ActivatedJob.newBuilder().setKey(jobKey.getValue()).setType(BufferUtil.bufferAsString((DirectBuffer)job.getTypeBuffer())).setBpmnProcessId(job.getBpmnProcessId()).setElementId(job.getElementId()).setProcessInstanceKey(job.getProcessInstanceKey()).setProcessDefinitionVersion(job.getProcessDefinitionVersion()).setProcessDefinitionKey(job.getProcessDefinitionKey()).setElementInstanceKey(job.getElementInstanceKey()).setCustomHeaders(ResponseMapper.bufferAsJson(job.getCustomHeadersBuffer())).setWorker(BufferUtil.bufferAsString((DirectBuffer)job.getWorkerBuffer())).setRetries(job.getRetries()).setDeadline(job.getDeadline()).setVariables(ResponseMapper.bufferAsJson(job.getVariablesBuffer())).build();
            responseBuilder.addJobs(activatedJob);
        }
        return responseBuilder.build();
    }

    public static GatewayOuterClass.ResolveIncidentResponse toResolveIncidentResponse(long key, IncidentRecord incident) {
        return GatewayOuterClass.ResolveIncidentResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.ModifyProcessInstanceResponse toModifyProcessInstanceResponse(long key, ProcessInstanceModificationRecord brokerResponse) {
        return GatewayOuterClass.ModifyProcessInstanceResponse.getDefaultInstance();
    }

    private static String bufferAsJson(DirectBuffer customHeaders) {
        return MsgPackConverter.convertToJson((byte[])BufferUtil.bufferAsArray((DirectBuffer)customHeaders));
    }

    @FunctionalInterface
    public static interface BrokerResponseMapper<BrokerResponseDto, GrpcResponseT> {
        public GrpcResponseT apply(long var1, BrokerResponseDto var3);
    }
}

