/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.admin.backup;

import io.camunda.zeebe.gateway.admin.IncompleteTopologyException;
import io.camunda.zeebe.gateway.admin.backup.BackupApi;
import io.camunda.zeebe.gateway.admin.backup.BackupStatus;
import io.camunda.zeebe.gateway.admin.backup.BackupStatusRequest;
import io.camunda.zeebe.gateway.admin.backup.BrokerBackupRequest;
import io.camunda.zeebe.gateway.admin.backup.PartitionBackupStatus;
import io.camunda.zeebe.gateway.cmd.NoTopologyAvailableException;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.camunda.zeebe.protocol.impl.encoding.BackupStatusResponse;
import io.camunda.zeebe.protocol.management.BackupStatusCode;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public final class BackupRequestHandler
implements BackupApi {
    final BrokerClient brokerClient;
    final BrokerTopologyManager topologyManager;

    public BackupRequestHandler(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
        this.topologyManager = brokerClient.getTopologyManager();
    }

    @Override
    public CompletionStage<Long> takeBackup(long backupId) {
        return this.checkTopologyComplete().thenCompose(topology -> CompletableFuture.allOf((CompletableFuture[])topology.getPartitions().stream().map(partitionId -> BackupRequestHandler.getBackupRequestForPartition(backupId, partitionId)).map(this.brokerClient::sendRequestWithRetry).toArray(CompletableFuture[]::new)).thenApply(ignore -> backupId));
    }

    @Override
    public CompletionStage<BackupStatus> getStatus(long backupId) {
        return this.checkTopologyComplete().thenCompose(topology -> {
            List<CompletableFuture> statusesReceived = topology.getPartitions().stream().map(partitionId -> this.getStatusQueryForPartition(backupId, (int)partitionId)).map(this.brokerClient::sendRequestWithRetry).toList();
            return CompletableFuture.allOf((CompletableFuture[])statusesReceived.toArray(CompletableFuture[]::new)).thenApply(ignore -> this.aggregatePartitionStatus(backupId, statusesReceived));
        });
    }

    private CompletionStage<BrokerClusterState> checkTopologyComplete() {
        int knownPartitions;
        BrokerClusterState topology = this.topologyManager.getTopology();
        if (topology == null) {
            return CompletableFuture.failedFuture(new NoTopologyAvailableException());
        }
        int expectedPartitionCount = topology.getPartitionsCount();
        if (expectedPartitionCount != (knownPartitions = topology.getPartitions().size())) {
            return CompletableFuture.failedFuture(new IncompleteTopologyException("Expected to send request to all %d partitions, but found only %d partitions in topology.".formatted(expectedPartitionCount, knownPartitions)));
        }
        return CompletableFuture.completedFuture(topology);
    }

    private BackupStatus aggregatePartitionStatus(long backupId, List<CompletableFuture<BrokerResponse<BackupStatusResponse>>> completedFutures) {
        List<PartitionBackupStatus> partitionStatuses = completedFutures.stream().map(response -> (BackupStatusResponse)((BrokerResponse)response.join()).getResponse()).map(PartitionBackupStatus::from).toList();
        BackupStatusCode combinedStatus = this.getAggregatedStatus(partitionStatuses);
        String failureReason = null;
        if (combinedStatus == BackupStatusCode.FAILED) {
            failureReason = this.collectFailureReason(partitionStatuses);
        }
        return new BackupStatus(backupId, combinedStatus, Optional.ofNullable(failureReason), partitionStatuses);
    }

    private String collectFailureReason(List<PartitionBackupStatus> partitionStatuses) {
        return partitionStatuses.stream().filter(p -> p.status() == BackupStatusCode.FAILED).map(p -> {
            String reason = p.failureReason().orElse("Unknown reason");
            return "Backup on partition %d failed due to %s. ".formatted(p.partitionId(), reason);
        }).collect(Collectors.joining());
    }

    private BackupStatusCode getAggregatedStatus(List<PartitionBackupStatus> partitionStatuses) {
        return partitionStatuses.stream().map(PartitionBackupStatus::status).reduce(this::combine).orElseThrow(() -> new IllegalStateException("Backup status cannot be calculated from status of partitions backup %s. Possible incomplete topology.".formatted(partitionStatuses)));
    }

    private BackupStatusCode combine(BackupStatusCode x, BackupStatusCode y) {
        if (x == BackupStatusCode.FAILED || y == BackupStatusCode.FAILED) {
            return BackupStatusCode.FAILED;
        }
        if (x == BackupStatusCode.DOES_NOT_EXIST || y == BackupStatusCode.DOES_NOT_EXIST) {
            return BackupStatusCode.DOES_NOT_EXIST;
        }
        if (x == BackupStatusCode.IN_PROGRESS || y == BackupStatusCode.IN_PROGRESS) {
            return BackupStatusCode.IN_PROGRESS;
        }
        if (x == BackupStatusCode.COMPLETED && y == BackupStatusCode.COMPLETED) {
            return BackupStatusCode.COMPLETED;
        }
        return BackupStatusCode.SBE_UNKNOWN;
    }

    private BackupStatusRequest getStatusQueryForPartition(long backupId, int partitionId) {
        BackupStatusRequest request = new BackupStatusRequest();
        request.setBackupId(backupId);
        request.setPartitionId(partitionId);
        return request;
    }

    private static BrokerBackupRequest getBackupRequestForPartition(long backupId, int partitionId) {
        BrokerBackupRequest request = new BrokerBackupRequest();
        request.setBackupId(backupId);
        request.setPartitionId(partitionId);
        return request;
    }
}

