/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.admin.backup;

import io.camunda.zeebe.gateway.admin.backup.PartitionBackupDescriptor;
import io.camunda.zeebe.protocol.impl.encoding.BackupStatusResponse;
import io.camunda.zeebe.protocol.management.BackupStatusCode;
import java.util.Optional;

public record PartitionBackupStatus(int partitionId, BackupStatusCode status, Optional<PartitionBackupDescriptor> description, Optional<String> failureReason, Optional<String> createdAt, Optional<String> lastUpdatedAt) {
    static PartitionBackupStatus from(BackupStatusResponse response) {
        BackupStatusCode status = response.getStatus();
        return switch (status) {
            case BackupStatusCode.FAILED -> PartitionBackupStatus.failedStatus(response);
            case BackupStatusCode.DOES_NOT_EXIST -> PartitionBackupStatus.notExistingStatus(response);
            case BackupStatusCode.IN_PROGRESS, BackupStatusCode.COMPLETED -> PartitionBackupStatus.validStatus(response);
            default -> throw new IllegalArgumentException("Unknown backup status %s".formatted(status));
        };
    }

    private static PartitionBackupStatus validStatus(BackupStatusResponse response) {
        PartitionBackupDescriptor descriptor = new PartitionBackupDescriptor(response.getSnapshotId(), response.getCheckpointPosition(), response.getBrokerId(), response.getBrokerVersion());
        return new PartitionBackupStatus(response.getPartitionId(), response.getStatus(), Optional.of(descriptor), Optional.empty(), Optional.ofNullable(response.getCreatedAt()), Optional.ofNullable(response.getLastUpdated()));
    }

    private static PartitionBackupStatus notExistingStatus(BackupStatusResponse response) {
        return new PartitionBackupStatus(response.getPartitionId(), BackupStatusCode.DOES_NOT_EXIST, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static PartitionBackupStatus failedStatus(BackupStatusResponse response) {
        return new PartitionBackupStatus(response.getPartitionId(), BackupStatusCode.FAILED, Optional.empty(), Optional.of(response.getFailureReason()), Optional.ofNullable(response.getCreatedAt()), Optional.ofNullable(response.getLastUpdated()));
    }
}

