/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.management;

import io.camunda.zeebe.backup.api.BackupManager;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopBackupManager
implements BackupManager {
    private static final Logger LOG = LoggerFactory.getLogger(NoopBackupManager.class);
    private final String errorMessage;

    public NoopBackupManager(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void takeBackup(long checkpointId, long checkpointPosition) {
        LOG.warn("Attempted to take backup, but cannot take backup. {}", (Object)this.errorMessage);
    }

    @Override
    public ActorFuture<BackupStatus> getBackupStatus(long checkpointId) {
        return CompletableActorFuture.completedExceptionally((Throwable)new UnsupportedOperationException(this.errorMessage));
    }

    @Override
    public ActorFuture<Void> deleteBackup(long checkpointId) {
        return CompletableActorFuture.completedExceptionally((Throwable)new UnsupportedOperationException(this.errorMessage));
    }

    @Override
    public ActorFuture<Void> closeAsync() {
        return CompletableActorFuture.completed(null);
    }

    @Override
    public void failInProgressBackup(long lastCheckpointId) {
        if (lastCheckpointId == -1L) {
            return;
        }
        LOG.warn("Attempted to update in progress backup, but cannot do it. {}", (Object)this.errorMessage);
    }
}

