/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public class BackupManagerMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String LABEL_NAME_PARTITION = "partition";
    private static final String LABEL_NAME_OPERATION = "operation";
    private static final String LABEL_NAME_RESULT = "result";
    private static final String FAILED = "failed";
    private static final String COMPLETED = "completed";
    private static final String TAKE_OPERATION = "take";
    private static final String STATUS_OPERATION = "status";
    private static final String DELETE_OPERATION = "delete";
    private static final Counter TOTAL_OPERATIONS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("backup_operations_total")).help("Total number of backup operations")).labelNames(new String[]{"partition", "operation", "result"})).register();
    private static final Gauge OPERATIONS_IN_PROGRESS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backup_operations_in_progress")).help("Number of backup operations that are in progress")).labelNames(new String[]{"partition", "operation"})).register();
    private static final Histogram BACKUP_OPERATION_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("backup_operations_latency")).help("Latency of backup operations")).labelNames(new String[]{"partition", "operation"})).buckets(new double[]{0.01, 0.1, 1.0, 10.0, 60.0, 300.0}).register();
    private final String partitionId;

    public BackupManagerMetrics(int partitionId) {
        this.partitionId = String.valueOf(partitionId);
    }

    public OperationMetrics startTakingBackup() {
        return OperationMetrics.start(this.partitionId, TAKE_OPERATION);
    }

    public OperationMetrics startQueryingStatus() {
        return OperationMetrics.start(this.partitionId, STATUS_OPERATION);
    }

    public OperationMetrics startDeleting() {
        return OperationMetrics.start(this.partitionId, DELETE_OPERATION);
    }

    public void cancelInProgressOperations() {
        ((Gauge.Child)OPERATIONS_IN_PROGRESS.labels(new String[]{this.partitionId, TAKE_OPERATION})).set(0.0);
        ((Gauge.Child)OPERATIONS_IN_PROGRESS.labels(new String[]{this.partitionId, DELETE_OPERATION})).set(0.0);
        ((Gauge.Child)OPERATIONS_IN_PROGRESS.labels(new String[]{this.partitionId, STATUS_OPERATION})).set(0.0);
    }

    public static final class OperationMetrics {
        final String partitionId;
        final Histogram.Timer timer;
        final String operation;

        private OperationMetrics(String partitionId, Histogram.Timer timer, String operation) {
            this.partitionId = partitionId;
            this.timer = timer;
            this.operation = operation;
        }

        private static OperationMetrics start(String partitionId, String operation) {
            Histogram.Timer timer = ((Histogram.Child)BACKUP_OPERATION_LATENCY.labels(new String[]{partitionId, operation})).startTimer();
            ((Gauge.Child)OPERATIONS_IN_PROGRESS.labels(new String[]{partitionId, operation})).inc();
            return new OperationMetrics(partitionId, timer, operation);
        }

        public <T> void complete(T ignored, Throwable throwable) {
            this.timer.close();
            ((Gauge.Child)OPERATIONS_IN_PROGRESS.labels(new String[]{this.partitionId, this.operation})).dec();
            if (throwable != null) {
                ((Counter.Child)TOTAL_OPERATIONS.labels(new String[]{this.partitionId, this.operation, BackupManagerMetrics.FAILED})).inc();
            } else {
                ((Counter.Child)TOTAL_OPERATIONS.labels(new String[]{this.partitionId, this.operation, BackupManagerMetrics.COMPLETED})).inc();
            }
        }
    }
}

