/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;

public class CheckpointMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String LABEL_NAME_PARTITION = "partition";
    private static final String LABEL_NAME_RESULT = "result";
    private static final Counter CHECKPOINT_RECORDS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("checkpoint_records_total")).help("Number of checkpoint records processed by stream processor. Processing can result in either creating a new checkpoint or ignoring the record. This can be observed by filtering for label 'result'.")).labelNames(new String[]{"result", "partition"})).register();
    private static final Gauge CHECKPOINT_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("checkpoint_position")).help("Position of the last checkpoint")).labelNames(new String[]{"partition"})).register();
    private static final Gauge CHECKPOINT_ID = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("checkpoint_id")).help("Id of the last checkpoint")).labelNames(new String[]{"partition"})).register();
    final String partitionId;

    public CheckpointMetrics(int partitionId) {
        this.partitionId = String.valueOf(partitionId);
    }

    public void created(long checkpointId, long checkpointPosition) {
        this.setCheckpointId(checkpointId, checkpointPosition);
        ((Counter.Child)CHECKPOINT_RECORDS.labels(new String[]{"created", this.partitionId})).inc();
    }

    public void setCheckpointId(long checkpointId, long checkpointPosition) {
        ((Gauge.Child)CHECKPOINT_ID.labels(new String[]{this.partitionId})).set((double)checkpointId);
        ((Gauge.Child)CHECKPOINT_POSITION.labels(new String[]{this.partitionId})).set((double)checkpointPosition);
    }

    public void ignored() {
        ((Counter.Child)CHECKPOINT_RECORDS.labels(new String[]{"ignored", this.partitionId})).inc();
    }
}

