/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.processing;

import io.camunda.zeebe.backup.api.BackupManager;
import io.camunda.zeebe.backup.api.CheckpointListener;
import io.camunda.zeebe.backup.metrics.CheckpointMetrics;
import io.camunda.zeebe.backup.processing.state.CheckpointState;
import io.camunda.zeebe.engine.api.ProcessingResult;
import io.camunda.zeebe.engine.api.ProcessingResultBuilder;
import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.management.CheckpointRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.management.CheckpointIntent;
import java.util.Set;

public final class CheckpointCreateProcessor {
    private final CheckpointState checkpointState;
    private final BackupManager backupManager;
    private final Set<CheckpointListener> listeners;
    private final CheckpointMetrics metrics;

    public CheckpointCreateProcessor(CheckpointState checkpointState, BackupManager backupManager, Set<CheckpointListener> listeners, CheckpointMetrics metrics) {
        this.checkpointState = checkpointState;
        this.backupManager = backupManager;
        this.listeners = listeners;
        this.metrics = metrics;
    }

    public ProcessingResult process(TypedRecord<CheckpointRecord> record, ProcessingResultBuilder resultBuilder) {
        CheckpointRecord checkpointRecord = (CheckpointRecord)record.getValue();
        long checkpointId = checkpointRecord.getCheckpointId();
        if (this.checkpointState.getCheckpointId() < checkpointId) {
            long checkpointPosition = record.getPosition();
            this.backupManager.takeBackup(checkpointId, checkpointPosition);
            this.checkpointState.setCheckpointInfo(checkpointId, checkpointPosition);
            this.listeners.forEach(l -> l.onNewCheckpointCreated(checkpointId));
            this.metrics.created(checkpointId, checkpointPosition);
            CheckpointRecord followupRecord = new CheckpointRecord().setCheckpointId(checkpointId).setCheckpointPosition(checkpointPosition);
            return this.createFollowUpAndResponse(record, CheckpointIntent.CREATED, followupRecord, resultBuilder);
        }
        this.metrics.ignored();
        return this.createFollowUpAndResponse(record, CheckpointIntent.IGNORED, checkpointRecord, resultBuilder);
    }

    private ProcessingResult createFollowUpAndResponse(TypedRecord<CheckpointRecord> command, CheckpointIntent resultIntent, CheckpointRecord checkpointRecord, ProcessingResultBuilder resultBuilder) {
        resultBuilder.appendRecord(command.getKey(), RecordType.EVENT, (Intent)resultIntent, RejectionType.NULL_VAL, "", (RecordValue)checkpointRecord);
        if (command.hasRequestMetadata()) {
            resultBuilder.withResponse(RecordType.EVENT, command.getKey(), (Intent)resultIntent, (UnpackedObject)checkpointRecord, ValueType.CHECKPOINT, RejectionType.NULL_VAL, "", command.getRequestId(), command.getRequestStreamId());
        }
        return resultBuilder.build();
    }
}

