/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.shared.ActorClockConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
final class ActorSchedulerComponent {
    private final GatewayCfg config;
    private final ActorClockConfiguration clockConfiguration;

    @Autowired
    ActorSchedulerComponent(GatewayCfg config, ActorClockConfiguration clockConfiguration) {
        this.config = config;
        this.clockConfiguration = clockConfiguration;
    }

    @Bean(destroyMethod="close")
    ActorScheduler actorScheduler() {
        return ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(this.config.getThreads().getManagementThreads()).setIoBoundActorThreadCount(0).setSchedulerName("gateway-scheduler").setActorClock((ActorClock)this.clockConfiguration.getClock().orElse(null)).build();
    }
}

